package yangtz.cs.liu.campus.domain.schoolDuty;

import java.util.List;
import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 值班管理对象 school_duty
 *
 */
@Data
public class SchoolDuty extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 标题 */
    @Excel(name = "标题")
    private String dutyName;

    /** 0节日、1寒暑假 */
    @Excel(name = "0节日、1寒暑假",readConverterExp = "0=节日,1=寒暑假")
    private String dutyType;

    /** 假日名称 */
    @Excel(name = "假日名称")
    private String holidayName;

    /** 值班开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "值班开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startDate;

    /** 值班结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "值班结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endDate;

    /** 说明 */
    @Excel(name = "说明")
    private String remarks;

    /** 状态*/
    @Excel(name = "状态",readConverterExp = "0=未发布,1=已发布")
    private String state;
}
