package yangtz.cs.liu.campus.domain.schoolDepartmentBudget;

import java.util.List;
import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 科室预算填报对象 school_department_budget
 *
 * @author ruoyi
 * @date 2023-07-11
 */
@Data
public class SchoolDepartmentBudget extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 科室预算填报主键id */
    private Long id;

    /** 流程实例id */
    private String instanceId;

    /** 年度 */
    private String year;

    /** 科室id */
    private Long deptId;

    /** 科室名称 */
    private String deptName;

    /** 填报人id */
    private Long informantId;

    /** 填报人名称 */
    private String informant;

    /** 分管领导id */
    private Long leadershipId;

    /** 分管领导名称 */
    private String leadershipName;

    /** 填报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date tbTime;

    /** 审核状态（0-未提交，1-分管领导审核，2-审核通过，3-审核不通过） */
    private String state;

    /** 申请人id */
    private Long applyId;

    /** 申请人 */
    private String applyName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 创建人id */
    private Long createById;

    /** 修改人id */
    private Long updateById;


    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setInstanceId(String instanceId)
    {
        this.instanceId = instanceId;
    }

    public String getInstanceId()
    {
        return instanceId;
    }
    public void setYear(String year)
    {
        this.year = year;
    }

    public String getYear()
    {
        return year;
    }
    public void setDeptId(Long deptId)
    {
        this.deptId = deptId;
    }

    public Long getDeptId()
    {
        return deptId;
    }
    public void setDeptName(String deptName)
    {
        this.deptName = deptName;
    }

    public String getDeptName()
    {
        return deptName;
    }
    public void setInformantId(Long informantId)
    {
        this.informantId = informantId;
    }

    public Long getInformantId()
    {
        return informantId;
    }
    public void setInformant(String informant)
    {
        this.informant = informant;
    }

    public String getInformant()
    {
        return informant;
    }
    public void setLeadershipId(Long leadershipId)
    {
        this.leadershipId = leadershipId;
    }

    public Long getLeadershipId()
    {
        return leadershipId;
    }
    public void setLeadershipName(String leadershipName)
    {
        this.leadershipName = leadershipName;
    }

    public String getLeadershipName()
    {
        return leadershipName;
    }
    public void setTbTime(Date tbTime)
    {
        this.tbTime = tbTime;
    }

    public Date getTbTime()
    {
        return tbTime;
    }
    public void setState(String state)
    {
        this.state = state;
    }

    public String getState()
    {
        return state;
    }
    public void setCreateById(Long createById)
    {
        this.createById = createById;
    }

    public Long getCreateById()
    {
        return createById;
    }
    public void setUpdateById(Long updateById)
    {
        this.updateById = updateById;
    }

    public Long getUpdateById()
    {
        return updateById;
    }


    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("instanceId", getInstanceId())
                .append("year", getYear())
                .append("deptId", getDeptId())
                .append("deptName", getDeptName())
                .append("informantId", getInformantId())
                .append("informant", getInformant())
                .append("leadershipId", getLeadershipId())
                .append("leadershipName", getLeadershipName())
                .append("tbTime", getTbTime())
                .append("state", getState())
                .append("createById", getCreateById())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateById", getUpdateById())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .toString();
    }
}
