package yangtz.cs.liu.campus.domain.schoolDcwj;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 接收人对象 school_dcwj_ry
 *
 * @author wengxiulin
 * @date 2023-03-01
 */
@Data
public class SchoolDcwjRy extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 学生ID */
    @Excel(name = "学生ID")
    private Long studentId;

    /** 调查问卷ID */
    @Excel(name = "调查问卷ID")
    private Long dcwjId;

    /** 是否填写(0否 1是) */
    @Excel(name = "是否填写(0否 1是)")
    private String ryZdzt;

    /** 初次填写时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "初次填写时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date ryCtime;

    /** 填写更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "填写更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date ryUtime;

    /** 教师ID */
    @Excel(name = "教师ID")
    private Long teacherId;
}
