package yangtz.cs.liu.campus.domain.schoolClass;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author xuten
 */
@Data
public class SchoolClassMentor extends OurBaseEntity {

    /** 老师主键 */
    @NotNull(message = "班级老师不能为空")
    private Long teacherId;

    /** 班级主键 */
    private Long classId;

    /** 课程id */
    @NotNull(message = "课程名称不能为空")
    private Long courseId;

    /** 课程名称 */
    private String courseName;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endTime;
}
