package yangtz.cs.liu.campus.domain.schoolAnnualAssessment;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import org.apache.poi.ss.usermodel.IndexedColors;

import java.util.Date;

/**
 * 年度考核对象 school_annual_assessment
 *
 * @author ruoyi
 * @date 2023-12-05
 */
@Data
public class SchoolAnnualAssessment {

    /** 主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 年度 */
    @Excel(name = "年度")
    private Integer year;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 身份证 */
    @Excel(name = "身份证")
    private String idCard;

    /** 考核结果(1优秀、2合格、3不定等次、4不予考核、5不合格、6记功、7嘉奖) */
    @Excel(name = "考核结果")
    private String checkResult;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 删除状态 */
    private String delFlag;
}
