package yangtz.cs.liu.campus.domain.recruit;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.List;

/**
 * @author xuten
 */
@Data
public class SchoolRecruitStudent extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /** 姓名 */
    @Excel(name = "姓名")
    private String studentName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 学籍号 */
    @Excel(name = "学籍号")
    private String studentNumber;

    /** 性别（0=男，1=女） */
    @Excel(name = "性别", readConverterExp = "0==男，1=女")
    private String sex;

    /** 身高（单位厘米） */
    @Excel(name = "身高", readConverterExp = "单=位厘米")
    private double height;

    /** 体重（单位千克） */
    @Excel(name = "体重", readConverterExp = "单=位千克")
    private double weight;

    /** 联系方式1 */
    @Excel(name = "联系方式1")
    private String telephone1;

    /** 联系方式2 */
    @Excel(name = "联系方式2")
    private String telephone2;

    /** 照片 */
    @Excel(name = "照片")
    private String photo;

    /** 手机号 */
    @Excel(name = "手机号")
    private String phoneNumber;

    /** 密码 */
    @Excel(name = "密码")
    private String password;



    /** 民族 */
    @Excel(name = "民族")
    private String mz;

    /** 政治面貌 */
    @Excel(name = "政治面貌")
    private String zzmm;

    /** 出生日期 */
    @Excel(name = "出生日期")
    private String csrq;

    /** 婚姻状况 */
    @Excel(name = "婚姻状况")
    private String hyzk;

    /** 户籍所在地 */
    @Excel(name = "户籍所在地")
    private String hjszd;

    /** 生源地 */
    @Excel(name = "生源地")
    private String syd;

    /** 考生身份 */
    @Excel(name = "考生身份")
    private String kssf;

    /** 参加工作时间 */
    @Excel(name = "参加工作时间")
    private String cjgzsj;

    /** 现工作单位职务 */
    @Excel(name = "现工作单位职务")
    private String xgzdwzw;

    /** 报考学历是否全日制 */
    @Excel(name = "报考学历是否全日制")
    private String bkxlsfqrz;

    /** 学历 */
    @Excel(name = "学历")
    private String xl;

    /** 学位 */
    @Excel(name = "学位")
    private String xw;

    /** 毕业学校 */
    @Excel(name = "毕业学校")
    private String byxx;

    /** 所学专业 */
    @Excel(name = "所学专业")
    private String sxzz;

    /** 最后毕业时间 */
    @Excel(name = "最后毕业时间")
    private String zhbysj;

//    /** 教师招聘 教师账号 信息从简历信息 */
//    private List<SchoolRecruitStudentJl> schoolRecruitStudentJlList;
}
