package yangtz.cs.liu.campus.domain.recruit;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import java.util.Date;
import lombok.Data;

@Data
public class SchoolRecruitRelation extends OurBaseEntity {

  /**
   * 考试id
   */
  @Excel(name = "考试id")
  private Long examId;

  /**
   * 学生id
   */
  @Excel(name = "学生id")
  private Long studentId;

  /**
   * 审核状态（只存在教育局信息时该字段没有值，0=驳回，1=通过，2 =退回修改,3=待审核）
   */
  @Excel(name = "审核状态", readConverterExp = "只=存在教育局信息时该字段没有值，0=驳回，1=通过，2,==退回修改,3=待审核")
  private String auditStatus;

  /**
   * 匹配状态（0=不匹配，1= 匹配，2=无教育局信息，3=未报名）
   */
  @Excel(name = "匹配状态", readConverterExp = "0==不匹配，1=,匹=配，2=无教育局信息，3=未报名")
  private String matchStatus;

  /**
   * 身份证号码
   */
  @Excel(name = "身份证号码")
  private String infoIdCard;

  /**
   * 初中学校id
   */
  @Excel(name = "初中学校id")
  private Long juniorId;

  /**
   * 测试项目id
   */
  @Excel(name = "测试项目id")
  private Long testId;

  /**
   * 提交状态(0=未提交，1=已提交)
   */
  @Excel(name = "提交状态(0=未提交，1=已提交)")
  private String submit;

  /**
   * 准考证号
   */
  @Excel(name = "准考证号")
  private String examNumber;

  /**
   * 分组
   */
  @Excel(name = "分组")
  private String inGroup;

  /**
   * 考试日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd")
  @Excel(name = "考试日期", width = 30, dateFormat = "yyyy-MM-dd")
  private Date examDate;

  /**
   * 考试时间
   */
  @Excel(name = "考试时间")
  private String examTime;

  /**
   * 考试地点
   */
  @Excel(name = "考试地点")
  private String examAddress;

  /**
   * 成绩
   */
  @Excel(name = "成绩")
  private String score;

  /**
   * 结果
   */
  @Excel(name = "结果")
  private String result;

  /**
   * 资格线
   */
  @Excel(name = "资格线")
  private String passScore;

  /**
   * 驳回意见
   */
  private String backMessage;
}
