package yangtz.cs.liu.campus.domain.material;

import java.util.List;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

/**
 * 课题、结题、专著、校本教材编写情况对象 material
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public class Material extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 教师id */
    private Long teacherId;

    /** 教师名称 */
    @Excel(name = "教师名称")
    private String teacherName;

    /** 名称 */
    @Excel(name = "名称")
    private String name;

    /** 发表时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "发表时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date publishTime;

    /** 附件信息信息 */
    private List<SchoolAccessory> schoolAccessoryList;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setTeacherId(Long teacherId)
    {
        this.teacherId = teacherId;
    }

    public Long getTeacherId()
    {
        return teacherId;
    }
    public void setTeacherName(String teacherName)
    {
        this.teacherName = teacherName;
    }

    public String getTeacherName()
    {
        return teacherName;
    }
    public void setName(String name)
    {
        this.name = name;
    }

    public String getName()
    {
        return name;
    }
    public void setPublishTime(Date publishTime)
    {
        this.publishTime = publishTime;
    }

    public Date getPublishTime()
    {
        return publishTime;
    }

    public List<SchoolAccessory> getSchoolAccessoryList()
    {
        return schoolAccessoryList;
    }

    public void setSchoolAccessoryList(List<SchoolAccessory> schoolAccessoryList)
    {
        this.schoolAccessoryList = schoolAccessoryList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("teacherId", getTeacherId())
                .append("teacherName", getTeacherName())
                .append("name", getName())
                .append("publishTime", getPublishTime())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("schoolAccessoryList", getSchoolAccessoryList())
                .toString();
    }
}
