package yangtz.cs.liu.campus.domain.exam;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;


@Data
public class ExamUserScore extends OurBaseEntity {

    private static final long serialVersionUID = 1L;

    /** 用户id */
    @Excel(name = "用户id")
    private Long userId;

    /** 分数 */
    @Excel(name = "分数")
    private Integer score;

    /** 答题时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "答题时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date answerTime;

    /** 考试id */
    @Excel(name = "考试id")
    private Long examId;

    /** 考试名称 */
    @Excel(name = "考试名称")
    private String examName;


}
