package yangtz.cs.liu.campus.domain.curricula;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 选课和科目关联对象
 */
@Data
public class CurriculaSub {

    /** 主键id */
    private Long id;

    /** 选课主键id */
    private Long curriculaId;

    /** 科目类型 */
    private String dictType;

    /** 科目名称 */
    private String dictLabel;

    /** 科目键值 */
    private String dictValue;

    /** 排序 */
    private Integer dictSort;

    /** 创建人 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
}
