package yangtz.cs.liu.campus.domain.conference;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 会议信息对象 school_conference
 *
 * @author ruoyi
 * @date 2022-10-05
 */
@Data
public class SchoolConference extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;


    /** 会议室 */
    @Excel(name = "会议室")
//    @NotNull(message = "会议室不能为空")
    private Long areaId;

    @Excel(name = "会议室详情")
//    @NotNull(message = "会议室详情不能为空")
    private Long detailId;

    //private String areaNo;

    /** 会议名称 */
    @Excel(name = "会议名称")
//    @NotBlank(message = "会议名称不能为空")
    private String conferenceName;

    /** 会议时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "会议时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
//    @NotNull(message = "会议开始时间不能为空")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    @NotNull(message = "会议结束时间不能为空")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 附件路径 */
    private String conferenceDataUrl;

    @Excel(name = "会议数据名称")
    private String conferenceDataName;

    /** 会议纪要 */
    @Excel(name = "会议纪要")
    private String conferenceSummary;


}

