package yangtz.cs.liu.campus.domain.area;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.core.utils.LogfieldUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

/**
 * 学校场地申请对象 school_area_apply
 * 
 * @author ruoyi
 * @date 2022-09-29
 */
@Data
public class SchoolAreaApply extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 场地id */
    @Excel(name = "场地id")
    private Long areaId;

    /** 场地详情id */
    @Excel(name = "场地详情id")
    private Long detailId;

    /** 申请老师ID */
    @Excel(name = "申请老师ID")
    private Long teacherId;

    /** 申请老师name */
    @Excel(name = "申请老师name")
    private String teacherName;

    /** type */
    @Excel(name = "请假类型")
    private String type;

    /** title */
    @Excel(name = "title")
    private String title;

    /** 开始使用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "开始使用时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /** 结束使用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "结束使用时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 状态 */
    private String state;

    /** 申请原因 */
    @Excel(name = "申请原因")
    private String reason;

    /** 流程id */
    @Excel(name = "流程id")
    private String instanceId;

    /** 申请人 */
    @Excel(name = "申请人")
    private String applyUser;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    //审批组
    private String roleKey;

//    public Map<String, Object> getParams()
//    {
//        if (params == null)
//        {
//            params = new HashMap<>();
//        }
//        return params;
//    }
//
//    public void setParams(Map<String, Object> params)
//    {
//        this.params = params;
//    }

//    /**
//     *  插入记录时日志字段补全策略
//     */
//    public void insert() {
//        LogfieldUtil.insert(this);
//    }
//
//    /**
//     *  更新记录时日志字段补全策略
//     */
//    public void  update() {
//        LogfieldUtil.update(this);
//    }
}
