package yangtz.cs.liu.campus.domain.SchoolStudentIntegral;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 学生积分对象 school_student_integral
 *
 * @author hxz
 * @date 2023-02-23
 */
@Data
public class SchoolStudentIntegral extends OurBaseEntity {
    /** 事件描述 */
    @Excel(name = "事件描述")
    @NotBlank(message = "事件描述不能为空")
    private String eventDescription;

    /** 奖惩 */
    @Excel(name = "奖惩",readConverterExp = "0=惩,1=奖")
    @NotBlank(message = "奖惩不能为空")
    private String isReward;

    /** 分值 */
    @Excel(name = "分值")
    @NotNull(message = "分值不能为空")
    private Double score;

    /** 日期 */
    @NotNull(message = "日期不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date day;

    /** 级别（0级部 1班级） */
    @NotBlank(message = "级别不能为空")
    @Excel(name = "级别", readConverterExp = "0=级部,1=班级")
    private String level;

    /** 所处学年 */
    //@Excel(name = "所处学年")
    private Integer schoolYear;

    /** 学期(0上学期 1下学期) */
    //@Excel(name = "学期(0上学期 1下学期)")
    private Integer term;

    /** 学生id */
    //@Excel(name = "学生id")
    @NotNull(message = "学生id不能为空")
    private Long studentId;
}
