package yangtz.cs.liu.campus.controller.xcgl;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.teacher.*;
import yangtz.cs.liu.campus.service.teacher.*;

import java.util.List;

@RestController
@RequestMapping("/teacher/teacherjy")
public class TeacherJyController extends BaseController {

    @Autowired
    private TeacherJyService teacherJyService;

    @Autowired
    private TeacherLyService teacherLyService;

    @Autowired
    private TeacherBxService teacherBxService;

    @Autowired
    private ShebeiJyService shebeiJyService;

    @Autowired
    private ShebeiLyService shebeiLyService;

    @Autowired
    private ShebeiBxService shebeiBxService;


    //教师端借用
    @GetMapping("/jylist")
    public TableDataInfo jylist(TeacherJy teacherJy){
//        startPage();

        List<TeacherJy> list= teacherJyService.queryList(teacherJy);
        return getDataTable(list);
    }

    //教师端领用
    @GetMapping("/lylist")
    public TableDataInfo lylist(TeacherLy teacherLy){
        startPage();
        List<TeacherLy> list=teacherLyService.queryList1(teacherLy);
        return getDataTable(list);
    }
//教师报修
    @GetMapping("/bxlist")
    public TableDataInfo bxlist(TeacherBx teacherBx){
        startPage();
        List<TeacherBx> list=teacherBxService.querylistbx(teacherBx);
        return getDataTable(list);
    }
    //借用单台设备查看
    @GetMapping("/ckjy")
    public AjaxResult shebeilist(ShebeiJy shebeiJy){
        ShebeiJy list= shebeiJyService.shebeilist(shebeiJy);
        return AjaxResult.success(list);
    }

    //领用单台设备查看
    @GetMapping("/ckly")
    public AjaxResult shebeilist1(ShebeiLy shebeiLy){
        ShebeiLy list=shebeiLyService.shebeilist1(shebeiLy);
        return AjaxResult.success(list);
    }

    //报修单台设备查看
    @GetMapping("/ckbx")
    public AjaxResult shebeilist2(ShebeiBx shebeiBx){
        ShebeiBx list=shebeiBxService.shebeilist2(shebeiBx);
        return AjaxResult.success(list);
    }
}
