package yangtz.cs.liu.campus.controller.teacherFiles;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesNotice;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesNoticeTotal;
import yangtz.cs.liu.campus.service.impl.teacherFiles.TeacherFilesExcelUtil;
import yangtz.cs.liu.campus.service.teacherFiles.ITeacherFilesNoticeService;

import javax.annotation.security.PermitAll;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 教师档案通知Controller
 * 
 * @author ruoyi
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/teacherFiles/notice")
public class TeacherFilesNoticeController extends BaseController
{
    @Autowired
    private ITeacherFilesNoticeService teacherFilesNoticeService;

    @Autowired
    private TeacherFilesExcelUtil teacherFilesExcelUtil;

    /**
     * 查询教师档案通知列表
     */
//    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:list')")
    @GetMapping("/list")
    public TableDataInfo list(TeacherFilesNotice teacherFilesNotice)
    {
        startPage();
        List<TeacherFilesNoticeTotal> list = teacherFilesNoticeService.selectTeacherFilesNoticeList(teacherFilesNotice);
        return getDataTable(list);
    }


    /**
     * 导出教师档案通知列表
     */
    @GetMapping("/export")
    @PermitAll
    public void export(HttpServletResponse response, TeacherFilesNotice teacherFilesNotice)
    {
        teacherFilesExcelUtil.getExcel(teacherFilesNotice.getId(),response);
    }

    /**
     * 获取教师档案通知详细信息
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(teacherFilesNoticeService.selectTeacherFilesNoticeById(id));
    }

    /**
     * 新增教师档案通知
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:add')")
    @Log(title = "教师档案通知", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TeacherFilesNotice teacherFilesNotice)
    {
        return toAjax(teacherFilesNoticeService.insertTeacherFilesNotice(teacherFilesNotice));
    }

    /**
     * 修改教师档案通知
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:edit')")
    @Log(title = "教师档案通知", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TeacherFilesNotice teacherFilesNotice)
    {
        return toAjax(teacherFilesNoticeService.updateTeacherFilesNotice(teacherFilesNotice));
    }

    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:edit')")
    @Log(title = "教师档案通知发布", businessType = BusinessType.UPDATE)
    @PutMapping("/release/{id}")
    public AjaxResult release(@PathVariable("id") String id)
    {
        return toAjax(teacherFilesNoticeService.release(id));
    }

    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:edit')")
    @Log(title = "教师档案通知撤回", businessType = BusinessType.UPDATE)
    @PutMapping("/withdraw/{id}")
    public AjaxResult withdraw(@PathVariable("id") String id)
    {
        return toAjax(teacherFilesNoticeService.withdraw(id));
    }

    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:edit')")
    @Log(title = "教师档案通知完成", businessType = BusinessType.UPDATE)
    @PutMapping("/complete/{id}")
    public AjaxResult complete(@PathVariable("id") String id)
    {
        return toAjax(teacherFilesNoticeService.complete(id));
    }

    /**
     * 删除教师档案通知
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:remove')")
    @Log(title = "教师档案通知", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable("ids")  String[] ids)
    {
        return toAjax(teacherFilesNoticeService.deleteTeacherFilesNoticeById(ids));
    }

}
