package yangtz.cs.liu.campus.controller.teacher;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.activiti.service.IProcessService;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherOvertime;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherOvertimeService;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherOvertimeVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherOvertimeVO;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.core.constant.ProcessDefinition.*;
import static com.ruoyi.common.core.domain.AjaxResult.error;
import static com.ruoyi.common.core.domain.AjaxResult.success;
import static yangtz.cs.liu.campus.constant.ProcessState.PASS;
import static yangtz.cs.liu.campus.constant.ProcessState.REFUSE;

/**
 * 学校老师加班Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/teacherOvertime")
public class SchoolTeacherOvertimeController extends BaseController {

    @Autowired
    private ISchoolTeacherOvertimeService schoolTeacherOvertimeService;

    @Autowired
    private IProcessService processService;

    /**
     * 查询老师加班列表
     */
//    @PreAuthorize("@ss.hasPermi('school:teacherOvertime:list')")
    @GetMapping("/list")
    public TableDataInfo list(String submitState, SchoolTeacherOvertimeVO schoolTeacherOvertimeVO) {
        startPage();
        List<SchoolTeacherOvertimeVO> list = schoolTeacherOvertimeService.selectSchoolTeacherOvertimeList(submitState, schoolTeacherOvertimeVO);
        return getDataTable(list);
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Integer id) {
        return AjaxResult.success(schoolTeacherOvertimeService.getById(id));
    }

    /**
     * 新增
     *
     * @param schoolTeacherOvertime
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolTeacherOvertime schoolTeacherOvertime) {
//        schoolTeacherOvertime.setType("teacherOvertime");
        return toAjax(schoolTeacherOvertimeService.save(schoolTeacherOvertime));
    }

    /**
     * 修改
     *
     * @param schoolTeacherOvertime
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolTeacherOvertime schoolTeacherOvertime) {
        if (StringUtils.isNull(schoolTeacherOvertime.getId())) {
            return AjaxResult.error("老师加班id未传");
        }
        return toAjax(schoolTeacherOvertimeService.updateById(schoolTeacherOvertime));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolTeacherOvertimeService.removeSchoolTeacherOvertimeById(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolTeacherOvertime> list = schoolTeacherOvertimeService.listByIds(ids);
        ExcelUtil<SchoolTeacherOvertime> util = new ExcelUtil<>(SchoolTeacherOvertime.class);
        util.exportExcel(response, list, "老师加班信息");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolTeacherOvertime schoolTeacherOvertime) {
        LambdaQueryWrapper<SchoolTeacherOvertime> lqw = new LambdaQueryWrapper<>();
        lqw
                .orderByDesc(SchoolTeacherOvertime::getCreateTime)
        ;
        List<SchoolTeacherOvertime> list = schoolTeacherOvertimeService.list(lqw);
        ExcelUtil<SchoolTeacherOvertime> util = new ExcelUtil<>(SchoolTeacherOvertime.class);
        util.exportExcel(response, list, "老师加班信息");
    }

    /**
     * 提交申请
     */
    @Log(title = "加班业务", businessType = BusinessType.UPDATE)
    @PostMapping("/submitApply/{id}")
    @ResponseBody
    public AjaxResult submitApply(@PathVariable Long id) {
        SchoolTeacherOvertime schoolTeacherOvertime = schoolTeacherOvertimeService.getById(id);
        if (StringUtils.isNull(schoolTeacherOvertime)) {
            throw new ServiceException("提交申请失败,未查询到相关信息");
        }
        String userName = getUsername();
        schoolTeacherOvertime.setApplyUser(userName);
        schoolTeacherOvertime.setApplyTime(DateUtils.getNowDate());
        return toAjax(schoolTeacherOvertimeService.submitApply(schoolTeacherOvertime, userName, TEACHEROVERTIME, new HashMap<>()));
    }

    /**
     * 待办事项列表
     */
    @GetMapping("/taskList")
    public TableDataInfo taskList(SchoolTeacherOvertime entity) {
        List<TeacherOvertimeVO> list = schoolTeacherOvertimeService.findTodoTasks(TEACHEROVERTIME, entity, getUserId().toString());
        return getDataTable(list);
    }

    /**
     * 完成任务
     */
    @PostMapping("/complete/{taskId}/{instanceId}")
    public AjaxResult complete(@PathVariable("taskId") String taskId, @PathVariable("instanceId") String instanceId, @RequestBody Map<String, Object> variables) {
        LambdaQueryWrapper<SchoolTeacherOvertime> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolTeacherOvertime::getInstanceId, instanceId);
        SchoolTeacherOvertime application = schoolTeacherOvertimeService.getOne(lqw);

        processService.completeTask(taskId, instanceId, variables);

        if (Boolean.parseBoolean(variables.get("pass").toString())) {
            application.setState(PASS);
        } else {
            application.setState(REFUSE);
        }
        schoolTeacherOvertimeService.updateById(application);
        return AjaxResult.success("任务完成成功");
    }

    /**
     * @author lyric
     * @date 2022/10/28 10:18
     * 销假
     */
    @PostMapping("/cancelLeave/{taskId}")
    public AjaxResult cancelLeave(@PathVariable("taskId") String taskId, @RequestBody SchoolTeacherOvertime schoolTeacherOvertime) {
        schoolTeacherOvertimeService.cancelLeave(taskId, schoolTeacherOvertime);
        return AjaxResult.success();
    }

    /**
     * 我的已办列表
     */
    @GetMapping("/taskDoneList")
    public TableDataInfo taskDoneList(SchoolTeacherOvertime entity) {
        List<TeacherOvertimeVO> list = schoolTeacherOvertimeService.findDoneTasks(TEACHEROVERTIME, entity, getUserId().toString());
        return getDataTable(list);
    }

}
