package yangtz.cs.liu.campus.controller.teacher;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherDuty;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherDutyService;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherDutyVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 学校老师值班Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/teacherDuty")
public class SchoolTeacherDutyController extends BaseController {

    @Autowired
    private ISchoolTeacherDutyService schoolTeacherDutyService;

    /**
     * 查询老师值班列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherDuty schoolTeacherDuty) {
        startPage();
        List<SchoolTeacherDuty> list = schoolTeacherDutyService.queryList(schoolTeacherDuty);
        return getDataTable(list);
    }

    /**
     * 首页值班表
     */
   /* @GetMapping("/dutyList")
    public TableDataInfo dutyList(SchoolTeacherDutyVO schoolTeacherDutyVO) {
        startPage();
        List<TeacherDutyMap> list = schoolTeacherDutyService.getList(schoolTeacherDutyVO);
        return getDataTable(list);
    }*/
    @GetMapping("/dutyList")
    public TableDataInfo dutyList(SchoolTeacherDutyVO schoolTeacherDutyVO) {
        startPage();
        List<SchoolTeacherDutyVO> list = schoolTeacherDutyService.getList(schoolTeacherDutyVO);
        return getDataTable(list);
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolTeacherDutyService.getById(id));
    }

    /**
     * 新增
     *
     * @param schoolTeacherDuty
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolTeacherDuty schoolTeacherDuty) {
        return toAjax(schoolTeacherDutyService.save(schoolTeacherDuty));
    }

    /**
     * 修改
     *
     * @param schoolTeacherDuty
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolTeacherDuty schoolTeacherDuty) {
        if (StringUtils.isNull(schoolTeacherDuty.getId())){
            return AjaxResult.error("老师值班id未传");
        }
        return toAjax(schoolTeacherDutyService.updateById(schoolTeacherDuty));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolTeacherDutyService.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolTeacherDuty> list = schoolTeacherDutyService.listByIds(ids);
        ExcelUtil<SchoolTeacherDuty> util = new ExcelUtil<>(SchoolTeacherDuty.class);
        util.exportExcel(response, list, "老师值班信息");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolTeacherDuty schoolTeacherDuty) {
        List<SchoolTeacherDuty> list = schoolTeacherDutyService.queryList(schoolTeacherDuty);
        ExcelUtil<SchoolTeacherDuty> util = new ExcelUtil<>(SchoolTeacherDuty.class);
        util.exportExcel(response, list, "老师值班信息");
    }


}
