package yangtz.cs.liu.campus.controller.student;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.student.SchoolStudentAward;
import yangtz.cs.liu.campus.service.student.ISchoolStudentAwardService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentAwardVo;

/**
 * 学生嘉奖Controller
 *
 * @author ruoyi
 * @date 2024-01-08
 */
@RestController
@RequestMapping("/school/studentAward")
public class SchoolStudentAwardController extends BaseController
{
    @Autowired
    private ISchoolStudentAwardService schoolStudentAwardService;

    /**
     * 查询学生嘉奖列表(全部)
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolStudentAward schoolStudentAward)
    {
        //过滤未提交的数据
        schoolStudentAward.setAuditState("0");
        startPage();
        List<SchoolStudentAward> list = schoolStudentAwardService.selectSchoolStudentAwardList(schoolStudentAward);
        return getDataTable(list);
    }

    /**
     * 查询学生嘉奖列表(个人)
     */
    @GetMapping("/listGr")
    public TableDataInfo listGr(SchoolStudentAward schoolStudentAward)
    {
        //获取当前登陆人id
        schoolStudentAward.setCreateById(SecurityUtils.getUserId());
        startPage();
        List<SchoolStudentAward> list = schoolStudentAwardService.selectSchoolStudentAwardList(schoolStudentAward);
        return getDataTable(list);
    }

    /**
     * 查询学生嘉奖列表(已通过)
     */
    @GetMapping("/listYtg")
    public TableDataInfo listYtg(SchoolStudentAward schoolStudentAward)
    {
        //查询已通过的数据
        schoolStudentAward.setAuditState("2");
        startPage();
        List<SchoolStudentAward> list = schoolStudentAwardService.selectSchoolStudentAwardListTg(schoolStudentAward);
        return getDataTable(list);
    }

    /**
     * 导出学生嘉奖列表(管理员)
     */
    @Log(title = "学生嘉奖", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolStudentAward schoolStudentAward)
    {
        //过滤未提交的数据
        schoolStudentAward.setAuditState("0");
        List<SchoolStudentAward> list = schoolStudentAwardService.selectSchoolStudentAwardList(schoolStudentAward);
        ExcelUtil<SchoolStudentAward> util = new ExcelUtil<SchoolStudentAward>(SchoolStudentAward.class);
        util.exportExcel(response, list, "学生嘉奖数据");
    }

    /**
     * 导出学生嘉奖列表(个人)
     */
    @Log(title = "学生嘉奖", businessType = BusinessType.EXPORT)
    @PostMapping("/exportGr")
    public void exportGr(HttpServletResponse response, SchoolStudentAward schoolStudentAward)
    {
        //获取当前登陆人id
        schoolStudentAward.setCreateById(SecurityUtils.getUserId());
        List<SchoolStudentAward> list = schoolStudentAwardService.selectSchoolStudentAwardList(schoolStudentAward);
        ExcelUtil<SchoolStudentAward> util = new ExcelUtil<SchoolStudentAward>(SchoolStudentAward.class);
        util.exportExcel(response, list, "学生嘉奖数据");
    }

    /**
     * 导出学生嘉奖列表(已通过)
     */
    @Log(title = "学生嘉奖", businessType = BusinessType.EXPORT)
    @PostMapping("/exportYtg")
    public void exportYtg(HttpServletResponse response, SchoolStudentAward schoolStudentAward)
    {
        schoolStudentAward.setAuditState("2");
        List<SchoolStudentAward> list = schoolStudentAwardService.selectSchoolStudentAwardList(schoolStudentAward);
        ExcelUtil<SchoolStudentAward> util = new ExcelUtil<SchoolStudentAward>(SchoolStudentAward.class);
        util.exportExcel(response, list, "学生嘉奖数据");
    }

    /**
     * 下载模板
     *
     * @return
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<SchoolStudentAwardVo> util = new ExcelUtil<>(SchoolStudentAwardVo.class);
        util.importTemplateExcel(response, "学生嘉奖");
    }

    /**
     * 导入(个人)
     *
     * @param file
     * @return
     * @throws Exception
     */
    @PostMapping("/importDataGr")
    public AjaxResult importDataGr(MultipartFile file) throws Exception {
        ExcelUtil<SchoolStudentAwardVo> util = new ExcelUtil<SchoolStudentAwardVo>(SchoolStudentAwardVo.class);
        List<SchoolStudentAwardVo> list = util.importExcel(file.getInputStream());
        //校验
        schoolStudentAwardService.checkImport(list);
        //导入
        list.forEach(list1 -> {
            list1.setCreateById(SecurityUtils.getUserId());
            list1.setCreateBy(SecurityUtils.getUsername());
            list1.setCreateTime(DateUtils.getNowDate());
        });
        String message = schoolStudentAwardService.importExamDetail(list);
        return AjaxResult.success(message);
    }

    /**
     * 导入(管理员)
     *
     * @param file
     * @return
     * @throws Exception
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file) throws Exception {
        ExcelUtil<SchoolStudentAwardVo> util = new ExcelUtil<SchoolStudentAwardVo>(SchoolStudentAwardVo.class);
        List<SchoolStudentAwardVo> list = util.importExcel(file.getInputStream());
        //校验
        schoolStudentAwardService.checkImport(list);
        //导入
        list.forEach(list1 -> {
            list1.setAuditState("2");
            list1.setCreateById(SecurityUtils.getUserId());
            list1.setCreateBy(SecurityUtils.getUsername());
            list1.setCreateTime(DateUtils.getNowDate());
        });
        String message = schoolStudentAwardService.importExamDetail(list);
        return AjaxResult.success(message);
    }


    /**
     * 获取学生嘉奖详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolStudentAwardService.selectSchoolStudentAwardById(id));
    }

    /**
     * 新增学生嘉奖(个人)
     */
    @Log(title = "学生嘉奖", businessType = BusinessType.INSERT)
    @PostMapping("/addGr")
    public AjaxResult addGr(@RequestBody SchoolStudentAward schoolStudentAward)
    {
        return toAjax(schoolStudentAwardService.insertSchoolStudentAward(schoolStudentAward));
    }

    /**
     * 新增学生嘉奖(管理员)
     */
    @Log(title = "学生嘉奖", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolStudentAward schoolStudentAward)
    {
        schoolStudentAward.setAuditState("2");
        return toAjax(schoolStudentAwardService.insertSchoolStudentAward(schoolStudentAward));
    }

    /**
     * 修改学生嘉奖
     */
    @Log(title = "学生嘉奖", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolStudentAward schoolStudentAward)
    {
        return toAjax(schoolStudentAwardService.updateSchoolStudentAward(schoolStudentAward));
    }

    /**
     * 删除学生嘉奖
     */
    @Log(title = "学生嘉奖", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolStudentAwardService.deleteSchoolStudentAwardByIds(ids));
    }

    /**
     * 提交审核
     */
    @PostMapping("/submit")
    @RepeatSubmit
    public AjaxResult submit(@RequestBody SchoolStudentAward schoolStudentAward){
        return toAjax(schoolStudentAwardService.submit(schoolStudentAward));
    }

    /**
     * 根据学生身份证号查询学生嘉奖信息
     */
    @GetMapping("/getStudentAwardList")
    public TableDataInfo getStudentAwardList(SchoolStudentAward schoolStudentAward){
        //查询已通过的数据
        schoolStudentAward.setAuditState("2");
        startPage();
        List<SchoolStudentAward> list = schoolStudentAwardService.selectSchoolStudentAwardListTg(schoolStudentAward);
        return getDataTable(list);
    }
}
