package yangtz.cs.liu.campus.controller.student;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.student.SchoolStudentAchievement;
import yangtz.cs.liu.campus.service.student.ISchoolStudentAchievementService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentAchievementVo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentAwardVo;

/**
 * 学生成绩Controller
 *
 * @author ruoyi
 * @date 2024-01-08
 */
@RestController
@RequestMapping("/school/studentAchievement")
public class SchoolStudentAchievementController extends BaseController
{
    @Autowired
    private ISchoolStudentAchievementService schoolStudentAchievementService;

    /**
     * 查询学生成绩列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolStudentAchievement schoolStudentAchievement)
    {
        startPage();
        List<SchoolStudentAchievement> list = schoolStudentAchievementService.selectSchoolStudentAchievementList(schoolStudentAchievement);
        return getDataTable(list);
    }

    /**
     * 查询学生成绩列表(个人)
     */
    @GetMapping("/listGr")
    public TableDataInfo listGr(SchoolStudentAchievement schoolStudentAchievement)
    {
        schoolStudentAchievement.setCreateById(SecurityUtils.getUserId());
        startPage();
        List<SchoolStudentAchievement> list = schoolStudentAchievementService.selectSchoolStudentAchievementList(schoolStudentAchievement);
        return getDataTable(list);
    }

    /**
     * 导出学生成绩列表
     */
    @Log(title = "学生成绩", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolStudentAchievement schoolStudentAchievement)
    {
        List<SchoolStudentAchievement> list = schoolStudentAchievementService.selectSchoolStudentAchievementList(schoolStudentAchievement);
        ExcelUtil<SchoolStudentAchievement> util = new ExcelUtil<SchoolStudentAchievement>(SchoolStudentAchievement.class);
        util.exportExcel(response, list, "学生成绩数据");
    }

    /**
     * 导出学生成绩列表(个人)
     */
    @Log(title = "学生成绩", businessType = BusinessType.EXPORT)
    @PostMapping("/exportGr")
    public void exportGr(HttpServletResponse response, SchoolStudentAchievement schoolStudentAchievement)
    {
        schoolStudentAchievement.setCreateById(SecurityUtils.getUserId());
        List<SchoolStudentAchievement> list = schoolStudentAchievementService.selectSchoolStudentAchievementList(schoolStudentAchievement);
        ExcelUtil<SchoolStudentAchievement> util = new ExcelUtil<SchoolStudentAchievement>(SchoolStudentAchievement.class);
        util.exportExcel(response, list, "学生成绩数据");
    }

    /**
     * 下载模板
     *
     * @return
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<SchoolStudentAchievementVo> util = new ExcelUtil<>(SchoolStudentAchievementVo.class);
        util.importTemplateExcel(response, "学生嘉奖");
    }

    /**
     * 导入
     *
     * @param file
     * @return
     * @throws Exception
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file) throws Exception {
        ExcelUtil<SchoolStudentAchievementVo> util = new ExcelUtil<SchoolStudentAchievementVo>(SchoolStudentAchievementVo.class);
        List<SchoolStudentAchievementVo> list = util.importExcel(file.getInputStream());
        //校验
        schoolStudentAchievementService.checkImport(list);
        //导入
        list.forEach(list1 -> {
            list1.setCreateById(SecurityUtils.getUserId());
            list1.setCreateBy(SecurityUtils.getUsername());
            list1.setCreateTime(DateUtils.getNowDate());
        });
        String message = schoolStudentAchievementService.importExamDetail(list);
        return AjaxResult.success(message);
    }

    /**
     * 获取学生成绩详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolStudentAchievementService.selectSchoolStudentAchievementById(id));
    }

    /**
     * 新增学生成绩
     */
    @Log(title = "学生成绩", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolStudentAchievement schoolStudentAchievement)
    {
        return toAjax(schoolStudentAchievementService.insertSchoolStudentAchievement(schoolStudentAchievement));
    }

    /**
     * 修改学生成绩
     */
    @Log(title = "学生成绩", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolStudentAchievement schoolStudentAchievement)
    {
        return toAjax(schoolStudentAchievementService.updateSchoolStudentAchievement(schoolStudentAchievement));
    }

    /**
     * 删除学生成绩
     */
    @Log(title = "学生成绩", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolStudentAchievementService.deleteSchoolStudentAchievementByIds(ids));
    }
}
