package yangtz.cs.liu.campus.controller.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.student.SchoolEducationDetails;
import yangtz.cs.liu.campus.service.student.ISchoolEducationDetailsService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 学校德育检查明细Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/educationDetails")
public class SchoolEducationDetailsController extends BaseController {

    @Autowired
    private ISchoolEducationDetailsService schoolEducationDetailsService;

    /**
     * 学生综合素质评价列表
     *
     * @param schoolEducationDetails
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolEducationDetails schoolEducationDetails) {
        startPage();
        List<SchoolEducationDetails> list = schoolEducationDetailsService.queryList(schoolEducationDetails);
        return getDataTable(list);
    }

    /**
     * 新增
     *
     * @param schoolEducationDetails
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolEducationDetails schoolEducationDetails) {
        return toAjax(schoolEducationDetailsService.save(schoolEducationDetails));
    }

    /**
     * 修改
     *
     * @param schoolEducationDetails
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolEducationDetails schoolEducationDetails) {
        if(StringUtils.isNull(schoolEducationDetails.getId())){
            return AjaxResult.error("德育详情id未传");
        }
        return toAjax(schoolEducationDetailsService.updateById(schoolEducationDetails));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Integer id) {
        return AjaxResult.success(schoolEducationDetailsService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        return toAjax(schoolEducationDetailsService.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolEducationDetails> list = schoolEducationDetailsService.listByIds(ids);
        ExcelUtil<SchoolEducationDetails> util = new ExcelUtil<>(SchoolEducationDetails.class);
        util.exportExcel(response, list, "学校德育检查明细");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolEducationDetails schoolEducationDetails) {
        LambdaQueryWrapper<SchoolEducationDetails> lqw = new LambdaQueryWrapper<>();
        lqw
                .orderByDesc(SchoolEducationDetails::getCreateTime)
        ;
        List<SchoolEducationDetails> list = schoolEducationDetailsService.list(lqw);
        ExcelUtil<SchoolEducationDetails> util = new ExcelUtil<>(SchoolEducationDetails.class);
        util.exportExcel(response, list, "学校德育检查明细");
    }

}
