package yangtz.cs.liu.campus.controller.schoolcalendar;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolcalendar.SchoolCalendar;
import yangtz.cs.liu.campus.domain.schoolcalendar.SchoolCalendarDetail;
import yangtz.cs.liu.campus.domain.schoolcalendar.SchoolCalendarSelecter;
import yangtz.cs.liu.campus.service.schoolcalendar.ISchoolCalendarDetailService;
import yangtz.cs.liu.campus.service.schoolcalendar.ISchoolCalendarService;
import yangtz.cs.liu.campus.vo.schoolcalendar.SchoolCalendarVo;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/schoolCalendar")
public class SchoolCalendarController extends BaseController {

    @Autowired
    private ISchoolCalendarService schoolCalendarService;

    @Autowired
    private ISchoolCalendarDetailService schoolCalendarDetailService;

    /**
     * 查询校历列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolCalendar schoolCalendar) {
            startPage();
            List<SchoolCalendarVo> list = schoolCalendarService.selectSchoolCalendarList(schoolCalendar);
            return getDataTable(list);
    }

    /**
     * 查询单个
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {

        SchoolCalendar schoolCalendar = schoolCalendarService.getById(id);
        return AjaxResult.success(schoolCalendarService.getById(id));
    }

    /**
     * 添加校历
     *
     * @param schoolCalendar
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolCalendar schoolCalendar) {
        return toAjax(schoolCalendarService.save(schoolCalendar));
    }

    /**
     * 修改校历（同编辑）
     *
     * @param schoolCalendar
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolCalendar schoolCalendar) {
        if (StringUtils.isNull(schoolCalendar.getId())) {
            throw new BaseException("修改主键id不能为空");
        }
        return toAjax(schoolCalendarService.updateSchoolCalendar(schoolCalendar));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/remove/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable("ids") List<Long> ids) {
            LambdaQueryWrapper<SchoolCalendarDetail> lqw = new LambdaQueryWrapper<>();
            lqw.in(SchoolCalendarDetail::getCalendarId, ids);
            schoolCalendarDetailService.remove(lqw);
            return toAjax(schoolCalendarService.removeByIds(ids));
    }

    /**
     * 下拉框查找校历
     *
     * @return
     */
    @GetMapping("/getSchoolCalendarForSelecter")
    public TableDataInfo getSchoolCalendarForSelecter(SchoolCalendarSelecter schoolCalendarSelecter) {

        List<SchoolCalendarSelecter> list = new ArrayList<>();
        List<SchoolCalendar> lr = schoolCalendarService.selectSchoolCalendarForSelecter(new SchoolCalendar());
        for (int i = 0; i < lr.size(); i++) {
            SchoolCalendarSelecter s = new SchoolCalendarSelecter();
            SchoolCalendar tmp = lr.get(i);
            String v = tmp.getCalendarName();
            String l = tmp.getCalendarName();
            s.setValue(v); // 属性值
            s.setLable(l); // 属性名称
            list.add(s);
        }
        return getDataTable(list);
    }

    /**
     * 导出部分校历列表
     *
     * @param response
     * @param ids
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolCalendar> list = schoolCalendarService.listByIds(ids);
        ExcelUtil<SchoolCalendar> util = new ExcelUtil<>(SchoolCalendar.class);
        util.exportExcel(response, list, "校历列表");
    }

    /**
     * 导出全部校历列表
     *
     * @param response
     * @param schoolCalendar
     */
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolCalendar schoolCalendar) {
        LambdaQueryWrapper<SchoolCalendar> lqw = new LambdaQueryWrapper<>();
        lqw
                .orderByDesc(SchoolCalendar::getCreateTime)
        ;
        List<SchoolCalendar> list = schoolCalendarService.list(lqw);
        ExcelUtil<SchoolCalendar> util = new ExcelUtil<>(SchoolCalendar.class);
        util.exportExcel(response, list, "校历列表");
    }


}
