package yangtz.cs.liu.campus.controller.schoolbudget;


import java.util.List;
import javax.servlet.http.HttpServletResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolbudget.SchoolBudgetDetails;
import yangtz.cs.liu.campus.service.schoolbudget.ISchoolBudgetDetailsService;

/**
 * 预算项目明细Controller
 * 
 * @author wengxiu
 * @date 2023-01-06
 */
@RestController
@RequestMapping("/budgetDetails")
public class SchoolBudgetDetailsController extends BaseController
{
    @Autowired
    private ISchoolBudgetDetailsService schoolBudgetDetailsService;

    /**
     * 查询列表
     */
    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TableDataInfo list(SchoolBudgetDetails schoolBudgetDetails)
    {
        startPage();
        List<SchoolBudgetDetails> list = schoolBudgetDetailsService.selectSchoolBudgetDetailsList(schoolBudgetDetails);
        return getDataTable(list);
    }

    /**
     * 导出列表
     */
    @Log(title = "导出列表", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolBudgetDetails schoolBudgetDetails)
    {
        List<SchoolBudgetDetails> list = schoolBudgetDetailsService.selectSchoolBudgetDetailsList(schoolBudgetDetails);
        ExcelUtil<SchoolBudgetDetails> util = new ExcelUtil<SchoolBudgetDetails>(SchoolBudgetDetails.class);
        util.exportExcel(response, list, "【请填写功能名称】数据");
    }

    /**
     * 获取详细信息
     */
    @ApiOperation("id查询")
    @GetMapping(value = "/queryById/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolBudgetDetailsService.getById(id));
    }

    /**
     * 新增预算项目明细
     */
    @Log(title = "新增预算项目明细", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolBudgetDetails schoolBudgetDetails)
    {
        return toAjax(schoolBudgetDetailsService.save(schoolBudgetDetails));
    }

    /**
     * 修改预算项目明细
     */
    @Log(title = "修改预算项目明细", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolBudgetDetails schoolBudgetDetails)
    {
        return toAjax(schoolBudgetDetailsService.updateById(schoolBudgetDetails));
    }

    /**
     * 删除预算项目明细
     */
    @Log(title = "删除预算项目明细", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Integer> ids)
    {
        return toAjax(schoolBudgetDetailsService.removeByIds(ids));
    }

    /**
     * 导入excel
     */
    @ApiOperation("导入excel")
    @PostMapping("/importExcel")
    public AjaxResult importExcel(MultipartFile file) throws Exception {
        return AjaxResult.success(schoolBudgetDetailsService.importListFromExcel(file));
    }


}
