package yangtz.cs.liu.campus.controller.schoolSecurity;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.service.schoolSecurity.ISchoolVideoConsultExternalService;
import yangtz.cs.liu.campus.vo.schoolSecurity.SchoolVideoConsultExternalVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 监控调阅（外部）Controller
 *
 * @author ruoyi
 * @date 2023-09-11
 */
@RestController
@RequestMapping("/schoolVideoConsultExternal")
public class SchoolVideoConsultExternalController extends BaseController
{

    @Autowired
    private ISchoolVideoConsultExternalService schoolVideoConsultExternalService;

    /**
     * 查询监控调阅（外部）列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo)
    {
        startPage();
        List<SchoolVideoConsultExternalVo> list = schoolVideoConsultExternalService.selectSchoolVideoConsultExternalList(schoolVideoConsultExternalVo);
        return getDataTable(list);
    }

    /**
     * 导出监控调阅（外部）列表
     */
    @Log(title = "监控调阅（外部）", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolVideoConsultExternalVo schoolVideoConsultExternalVo)
    {
        List<SchoolVideoConsultExternalVo> list = schoolVideoConsultExternalService.selectSchoolVideoConsultExternalList(schoolVideoConsultExternalVo);
        ExcelUtil<SchoolVideoConsultExternalVo> util = new ExcelUtil<SchoolVideoConsultExternalVo>(SchoolVideoConsultExternalVo.class);
        util.exportExcel(response, list, "监控调阅（外部）数据");
    }

    /**
     * 获取监控调阅（外部）详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolVideoConsultExternalService.selectSchoolVideoConsultExternalById(id));
    }

    /**
     * 新增监控调阅（外部）
     */
    @Log(title = "监控调阅（外部）", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolVideoConsultExternalVo schoolVideoConsultExternalVo)
    {
        return toAjax(schoolVideoConsultExternalService.insertSchoolVideoConsultExternal(schoolVideoConsultExternalVo));
    }

    /**
     * 修改监控调阅（外部）
     */
    @Log(title = "监控调阅（外部）", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolVideoConsultExternalVo schoolVideoConsultExternalVo)
    {
        return toAjax(schoolVideoConsultExternalService.updateSchoolVideoConsultExternal(schoolVideoConsultExternalVo));
    }

    /**
     * 删除监控调阅（外部）
     */
    @Log(title = "监控调阅（外部）", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolVideoConsultExternalService.deleteSchoolVideoConsultExternalByIds(ids));
    }
}
