package yangtz.cs.liu.campus.controller.schoolRewardsPunishments;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteachingAchievements;
import yangtz.cs.liu.campus.domain.schoolRewardsPunishments.SchoolScDiscipline;
import yangtz.cs.liu.campus.service.accessory.IAccessoryService;
import yangtz.cs.liu.campus.service.schoolRewardsPunishments.ISchoolScDisciplineService;
import yangtz.cs.liu.campus.vo.schoolRewardsPunishments.SchoolScDisciplineExport;
import yangtz.cs.liu.campus.vo.schoolRewardsPunishments.SchoolScDisciplineVo;

/**
 * 学生违纪Controller
 *
 * @author ruoyi
 * @date 2023-11-06
 */
@RestController
@RequestMapping("/school/discipline")
public class SchoolScDisciplineController extends BaseController
{
    @Autowired
    private ISchoolScDisciplineService schoolScDisciplineService;
    @Autowired
    private IAccessoryService accessoryService;

    /**
     * 查询学生违纪列表(管理员)
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolScDiscipline schoolScDiscipline)
    {
        schoolScDiscipline.setAuditState("0");
        startPage();
        List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineList(schoolScDiscipline);
        List<SchoolScDisciplineVo> schoolScDisciplineVoList = new ArrayList<>();
        //查询所有学生违纪附件
        LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAccessory::getAccessoryType,"学生违纪附件");
        List<SchoolAccessory> list1 = accessoryService.list(wrapper);
        for (SchoolScDiscipline scDiscipline : list) {
            //转vo
            SchoolScDisciplineVo schoolScDisciplineVo = new SchoolScDisciplineVo();
            BeanUtils.copyProperties(scDiscipline,schoolScDisciplineVo);

            List<SchoolAccessory> schoolAccessoryList = new ArrayList<>();
            for (SchoolAccessory schoolAccessory : list1) {
                if (scDiscipline.getId().equals(schoolAccessory.getBusinessId())){
                    schoolAccessoryList.add(schoolAccessory);
                }
            }
            if (schoolAccessoryList.size() > 0){
                schoolScDisciplineVo.setSchoolAccessoryList(schoolAccessoryList);
            }
            schoolScDisciplineVoList.add(schoolScDisciplineVo);
        }
        TableDataInfo tableDataInfo = getDataTable(schoolScDisciplineVoList);
        tableDataInfo.setTotal(new PageInfo(list).getTotal());
        return tableDataInfo;
    }

    /**
     * 查询学生违纪列表(查看已通过)
     */
    @GetMapping("/listTg")
    public TableDataInfo listTg(SchoolScDiscipline schoolScDiscipline)
    {
        schoolScDiscipline.setAuditState("2");
        startPage();
        List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineListTg(schoolScDiscipline);
        List<SchoolScDisciplineVo> schoolScDisciplineVoList = new ArrayList<>();
        //查询所有学生违纪附件
        LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAccessory::getAccessoryType,"学生违纪附件");
        List<SchoolAccessory> list1 = accessoryService.list(wrapper);
        for (SchoolScDiscipline scDiscipline : list) {
            //转vo
            SchoolScDisciplineVo schoolScDisciplineVo = new SchoolScDisciplineVo();
            BeanUtils.copyProperties(scDiscipline,schoolScDisciplineVo);

            List<SchoolAccessory> schoolAccessoryList = new ArrayList<>();
            for (SchoolAccessory schoolAccessory : list1) {
                if (scDiscipline.getId().equals(schoolAccessory.getBusinessId())){
                    schoolAccessoryList.add(schoolAccessory);
                }
            }
            if (schoolAccessoryList.size() > 0){
                schoolScDisciplineVo.setSchoolAccessoryList(schoolAccessoryList);
            }
            schoolScDisciplineVoList.add(schoolScDisciplineVo);
        }
        TableDataInfo tableDataInfo = getDataTable(schoolScDisciplineVoList);
        tableDataInfo.setTotal(new PageInfo(list).getTotal());
        return tableDataInfo;
    }

    /**
     * 查询学生违纪列表(个人)
     */
    @GetMapping("/listGr")
    public TableDataInfo listGr(SchoolScDiscipline schoolScDiscipline)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //管理员返回全部
        if (user.isAdmin()) {
            startPage();
            List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineList(schoolScDiscipline);
            return getDataTable(list);
        }
        schoolScDiscipline.setApplyId(SecurityUtils.getUserId());
        startPage();
        List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineList(schoolScDiscipline);
        List<SchoolScDisciplineVo> schoolScDisciplineVoList = new ArrayList<>();
        //查询所有学生违纪附件
        LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAccessory::getAccessoryType,"学生违纪附件");
        List<SchoolAccessory> list1 = accessoryService.list(wrapper);
        for (SchoolScDiscipline scDiscipline : list) {
            //转vo
            SchoolScDisciplineVo schoolScDisciplineVo = new SchoolScDisciplineVo();
            BeanUtils.copyProperties(scDiscipline,schoolScDisciplineVo);

            List<SchoolAccessory> schoolAccessoryList = new ArrayList<>();
            for (SchoolAccessory schoolAccessory : list1) {
                if (scDiscipline.getId().equals(schoolAccessory.getBusinessId())){
                    schoolAccessoryList.add(schoolAccessory);
                }
            }
            if (schoolAccessoryList.size() > 0){
                schoolScDisciplineVo.setSchoolAccessoryList(schoolAccessoryList);
            }
            schoolScDisciplineVoList.add(schoolScDisciplineVo);
        }
        TableDataInfo tableDataInfo = getDataTable(schoolScDisciplineVoList);
        tableDataInfo.setTotal(new PageInfo(list).getTotal());
        return tableDataInfo;
    }

    /**
     * 导出学生违纪列表(个人)
     */
    @Log(title = "学生违纪", businessType = BusinessType.EXPORT)
    @PostMapping("/exportGr")
    public void exportGr(HttpServletResponse response, SchoolScDiscipline schoolScDiscipline)
    {

        SysUser user = SecurityUtils.getLoginUser().getUser();
        //管理员导出全部
        if (user.isAdmin()) {
            List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineList(schoolScDiscipline);
            List<SchoolScDisciplineExport> exportList = new ArrayList<>();
            for (SchoolScDiscipline scDiscipline : list) {
                //转导出对象
                SchoolScDisciplineExport schoolScDisciplineExport = new SchoolScDisciplineExport();
                BeanUtils.copyProperties(scDiscipline,schoolScDisciplineExport);
                exportList.add(schoolScDisciplineExport);
            }
            ExcelUtil<SchoolScDisciplineExport> util = new ExcelUtil<SchoolScDisciplineExport>(SchoolScDisciplineExport.class);
            util.exportExcel(response, exportList, "学生违纪数据");
        }else{
            schoolScDiscipline.setApplyId(SecurityUtils.getUserId());
            List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineList(schoolScDiscipline);
            List<SchoolScDisciplineExport> exportList = new ArrayList<>();
            for (SchoolScDiscipline scDiscipline : list) {
                //转导出对象
                SchoolScDisciplineExport schoolScDisciplineExport = new SchoolScDisciplineExport();
                BeanUtils.copyProperties(scDiscipline,schoolScDisciplineExport);
                exportList.add(schoolScDisciplineExport);
            }
            ExcelUtil<SchoolScDisciplineExport> util = new ExcelUtil<SchoolScDisciplineExport>(SchoolScDisciplineExport.class);
            util.exportExcel(response, exportList, "学生违纪数据");
        }
    }

    /**
     * 导出学生违纪列表(已通过)
     */
    @Log(title = "学生违纪", businessType = BusinessType.EXPORT)
    @PostMapping("/exportYtg")
    public void exportYtg(HttpServletResponse response, SchoolScDiscipline schoolScDiscipline)
    {
        schoolScDiscipline.setAuditState("2");
        List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineListTg(schoolScDiscipline);
        List<SchoolScDisciplineExport> exportList = new ArrayList<>();
        for (SchoolScDiscipline scDiscipline : list) {
            //转导出对象
            SchoolScDisciplineExport schoolScDisciplineExport = new SchoolScDisciplineExport();
            BeanUtils.copyProperties(scDiscipline,schoolScDisciplineExport);
            exportList.add(schoolScDisciplineExport);
        }
        ExcelUtil<SchoolScDisciplineExport> util = new ExcelUtil<SchoolScDisciplineExport>(SchoolScDisciplineExport.class);
        util.exportExcel(response, exportList, "学生违纪数据");
    }

    /**
     * 导出学生违纪列表(管理员)
     */
    @Log(title = "学生违纪", businessType = BusinessType.EXPORT)
    @PostMapping("/exportGl")
    public void exportGl(HttpServletResponse response, SchoolScDiscipline schoolScDiscipline)
    {
        schoolScDiscipline.setAuditState("0");
        List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineList(schoolScDiscipline);
        List<SchoolScDisciplineExport> exportList = new ArrayList<>();
        for (SchoolScDiscipline scDiscipline : list) {
            //转导出对象
            SchoolScDisciplineExport schoolScDisciplineExport = new SchoolScDisciplineExport();
            BeanUtils.copyProperties(scDiscipline,schoolScDisciplineExport);
            exportList.add(schoolScDisciplineExport);
        }
        ExcelUtil<SchoolScDisciplineExport> util = new ExcelUtil<SchoolScDisciplineExport>(SchoolScDisciplineExport.class);
        util.exportExcel(response, exportList, "学生违纪数据");
    }

    /*
     * 下载模板
     * */
    @PostMapping("/importTemplate")
    public void importTemplate (HttpServletResponse response) {
        schoolScDisciplineService.importTemplate(response);
    }

    /**
     * 导入学生违纪(个人)
     */
//    @PreAuthorize("@ss.hasPermi('system:achievements:importData')")
    @PostMapping("/importDataGr")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult importDataGr(MultipartFile file) throws Exception {
        ExcelUtil<SchoolScDisciplineVo> util = new ExcelUtil<SchoolScDisciplineVo>(SchoolScDisciplineVo.class);
        List<SchoolScDisciplineVo> list = util.importExcelNdkh(file.getInputStream());
        //先校验
        schoolScDisciplineService.checkImport(list);
        //数据导入
        list.forEach(list1 -> {
            list1.setApplyId(SecurityUtils.getUserId());
            list1.setApplyName(SecurityUtils.getUsername());
            list1.setApplyTime(DateUtils.getNowDate());
            list1.setCreateBy(SecurityUtils.getUsername());
            list1.setCreateTime(DateUtils.getNowDate());
        });
        String message = schoolScDisciplineService.importData(list);
        return AjaxResult.success(message);
    }

    /**
     * 导入学生违纪(管理员)
     */
//    @PreAuthorize("@ss.hasPermi('system:achievements:importData')")
    @PostMapping("/importData")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult importData(MultipartFile file) throws Exception {
        ExcelUtil<SchoolScDisciplineVo> util = new ExcelUtil<SchoolScDisciplineVo>(SchoolScDisciplineVo.class);
        List<SchoolScDisciplineVo> list = util.importExcelNdkh(file.getInputStream());
        //先校验
        schoolScDisciplineService.checkImport(list);
        //数据导入
        list.forEach(list1 -> {
            list1.setAuditState("1");
            list1.setApplyId(SecurityUtils.getUserId());
            list1.setApplyName(SecurityUtils.getUsername());
            list1.setApplyTime(DateUtils.getNowDate());
            list1.setCreateBy(SecurityUtils.getUsername());
            list1.setCreateTime(DateUtils.getNowDate());
        });
        String message = schoolScDisciplineService.importData(list);
        return AjaxResult.success(message);
    }


    /**
     * 获取学生违纪详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolScDisciplineService.selectSchoolScDisciplineById(id));
    }

    /**
     * 新增学生违纪(管理员)
     */
    @Log(title = "学生违纪", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolScDisciplineVo schoolScDisciplineVo)
    {
        schoolScDisciplineVo.setAuditState("1");
        return toAjax(schoolScDisciplineService.insertSchoolScDiscipline(schoolScDisciplineVo));
    }

    /**
     * 新增学生违纪(个人)
     */
    @Log(title = "学生违纪", businessType = BusinessType.INSERT)
    @PostMapping("/addGr")
    public AjaxResult addGr(@RequestBody SchoolScDisciplineVo schoolScDisciplineVo)
    {
        return toAjax(schoolScDisciplineService.insertSchoolScDiscipline(schoolScDisciplineVo));
    }

    /**
     * 修改学生违纪
     */
    @Log(title = "学生违纪", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolScDisciplineVo schoolScDisciplineVo)
    {
        return toAjax(schoolScDisciplineService.updateSchoolScDiscipline(schoolScDisciplineVo));
    }

    /**
     * 删除学生违纪
     */
    @Log(title = "学生违纪", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolScDisciplineService.deleteSchoolScDisciplineByIds(ids));
    }

    /**
     * 提交/审核
     */
    @PutMapping("/submit")
    public AjaxResult submit(@RequestBody SchoolScDiscipline schoolScDiscipline)
    {
        return toAjax(schoolScDisciplineService.updateById(schoolScDiscipline));
    }

    /**
     * 获取最新三个年级
     */
    @GetMapping("/getGrade")
    public AjaxResult getGrade(){
        return AjaxResult.success(schoolScDisciplineService.getGrade());
    }

    /**
     * 根据年级获取班级
     */
    @GetMapping("/getClassList")
    public AjaxResult getClassList(Long gradeId){
        return AjaxResult.success(schoolScDisciplineService.getClassList(gradeId));
    }

    /**
     * 根据身份证号查询学生违纪列表
     */
    @GetMapping("/getDisciplineList")
    public TableDataInfo getDisciplineList(SchoolScDiscipline schoolScDiscipline){
        schoolScDiscipline.setAuditState("2");
        startPage();
        List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineListTg(schoolScDiscipline);
        List<SchoolScDisciplineVo> schoolScDisciplineVoList = new ArrayList<>();
        //查询所有学生违纪附件
        LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAccessory::getAccessoryType,"学生违纪附件");
        List<SchoolAccessory> list1 = accessoryService.list(wrapper);
        for (SchoolScDiscipline scDiscipline : list) {
            //转vo
            SchoolScDisciplineVo schoolScDisciplineVo = new SchoolScDisciplineVo();
            BeanUtils.copyProperties(scDiscipline,schoolScDisciplineVo);

            List<SchoolAccessory> schoolAccessoryList = new ArrayList<>();
            for (SchoolAccessory schoolAccessory : list1) {
                if (scDiscipline.getId().equals(schoolAccessory.getBusinessId())){
                    schoolAccessoryList.add(schoolAccessory);
                }
            }
            if (schoolAccessoryList.size() > 0){
                schoolScDisciplineVo.setSchoolAccessoryList(schoolAccessoryList);
            }
            schoolScDisciplineVoList.add(schoolScDisciplineVo);
        }
        TableDataInfo tableDataInfo = getDataTable(schoolScDisciplineVoList);
        tableDataInfo.setTotal(new PageInfo(list).getTotal());
        return tableDataInfo;
    }
}
