package yangtz.cs.liu.campus.controller.schoolNewTeacherDzdn;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.system.service.ISysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolGkAchievementVo;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteamAward;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteamAwardVo;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteachingAchievementsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteamAwardService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;

/**
 * 团队获奖Controller
 *
 * @author ruoyi
 * @date 2023-12-13
 */
@RestController
@RequestMapping("/school/award")
public class SchoolXteamAwardController extends BaseController
{
    @Autowired
    private ISchoolXteamAwardService schoolXteamAwardService;
    @Autowired
    private ISchoolXteachingAchievementsService schoolXteachingAchievementsService;
    @Autowired
    private ISysDeptService sysDeptService;
    @Autowired
    private SchoolTeacherBasichlnformationService basichlnformationService;

    /**
     * 查询团队获奖列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolXteamAwardVo schoolXteamAwardVo)
    {
        schoolXteamAwardVo.setNoAuditState("0");

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            startPage();
            List<SchoolXteamAwardVo> list = schoolXteamAwardService.selectSchoolXteamAwardVoList(schoolXteamAwardVo);
            return getDataTable(list);
        }

        //全部权限
        List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("tdhj_admin")).collect(Collectors.toList());
        if (roleList.size() > 0){
            startPage();
            List<SchoolXteamAwardVo> list = schoolXteamAwardService.selectSchoolXteamAwardVoList(schoolXteamAwardVo);
            return getDataTable(list);
        }
        //部分权限
        List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
        //查询是否包含学科组长角色
        List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
        if (roleList1.size() > 0){
            //教师电子档案中级管理员只能查看本部门及部门以下的数据
            //根据用户部门id查询用户部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            //查询本部门下所有教师的id
            List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
            if (deptUserIds.size() > 0){
                schoolXteamAwardVo.setUserIds(deptUserIds);
            }
            if (roleList2.size() > 0){
                //根据当前登陆人手机号查询任教学科
                String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                schoolXteamAwardVo.setSub1(sub);
            }
            startPage();
            List<SchoolXteamAwardVo> list = schoolXteamAwardService.selectSchoolXteamAwardVoList(schoolXteamAwardVo);
            return getDataTable(list);
        }
        if (roleList2.size() > 0){
            //根据当前登陆人手机号查询任教学科
            String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
            schoolXteamAwardVo.setSub1(sub);
            startPage();
            List<SchoolXteamAwardVo> list = schoolXteamAwardService.selectSchoolXteamAwardVoList(schoolXteamAwardVo);
            return getDataTable(list);
        }
        return getDataTable(new ArrayList<>());
    }

    /**
     * 团队获奖个人页面查询
     */
    @GetMapping("/personlist")
    public TableDataInfo personlist(SchoolXteamAwardVo schoolXteamAwardVo)
    {

        startPage();
        List<SchoolXteamAwardVo> list = schoolXteamAwardService.selectSchoolXteamAwardVoList(schoolXteamAwardVo);
        return getDataTable(list);

    }


    /**
     * 导出团队获奖列表
     */
    @Log(title = "团队获奖", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolXteamAwardVo schoolXteamAwardVo)
    {

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            List<SchoolXteamAward> list = schoolXteamAwardService.selectSchoolXteamAwardList(schoolXteamAwardVo);
            ExcelUtil<SchoolXteamAward> util = new ExcelUtil<SchoolXteamAward>(SchoolXteamAward.class);
            util.exportExcel(response, list, "团队获奖数据");
        }else {

            //全部权限
            List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("tdhj_admin")).collect(Collectors.toList());
            if (roleList.size() > 0){
                List<SchoolXteamAward> list = schoolXteamAwardService.selectSchoolXteamAwardList(schoolXteamAwardVo);
                ExcelUtil<SchoolXteamAward> util = new ExcelUtil<SchoolXteamAward>(SchoolXteamAward.class);
                util.exportExcel(response, list, "团队获奖数据");
            }else {
                //部分权限
                List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
                //查询是否包含学科组长角色
                List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
                if (roleList1.size() > 0){
                    //教师电子档案中级管理员只能查看本部门及部门以下的数据
                    //根据用户部门id查询用户部门信息
                    SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
                    //查询本部门下所有教师的id
                    List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
                    if (deptUserIds.size() > 0){
                        schoolXteamAwardVo.setUserIds(deptUserIds);
                    }
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolXteamAwardVo.setSub1(sub);
                    }
                    List<SchoolXteamAward> list = schoolXteamAwardService.selectSchoolXteamAwardList(schoolXteamAwardVo);
                    ExcelUtil<SchoolXteamAward> util = new ExcelUtil<SchoolXteamAward>(SchoolXteamAward.class);
                    util.exportExcel(response, list, "团队获奖数据");
                }else {
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolXteamAwardVo.setSub1(sub);
                        List<SchoolXteamAward> list = schoolXteamAwardService.selectSchoolXteamAwardList(schoolXteamAwardVo);
                        ExcelUtil<SchoolXteamAward> util = new ExcelUtil<SchoolXteamAward>(SchoolXteamAward.class);
                        util.exportExcel(response, list, "团队获奖数据");
                    }else {
                        ExcelUtil<SchoolXteamAward> util = new ExcelUtil<SchoolXteamAward>(SchoolXteamAward.class);
                        util.exportExcel(response, new ArrayList<>(), "团队获奖数据");
                    }
                }
            }
        }
    }

    /**
     * 获取团队获奖详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolXteamAwardService.selectSchoolXteamAwardById(id));
    }

    /**
     * 新增团队获奖
     */
    @Log(title = "团队获奖", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolXteamAward schoolXteamAward)
    {
        Long userId = SecurityUtils.getLoginUser().getUser().getUserId();
        schoolXteamAward.setCreateBy(userId.toString());
        return toAjax(schoolXteamAwardService.insertSchoolXteamAward(schoolXteamAward));
    }

    /**
     * 修改团队获奖
     */
    @Log(title = "团队获奖", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolXteamAward schoolXteamAward)
    {
        return toAjax(schoolXteamAwardService.updateSchoolXteamAward(schoolXteamAward));
    }

    /**
     * 删除团队获奖
     */
    @Log(title = "团队获奖", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolXteamAwardService.deleteSchoolXteamAwardByIds(ids));
    }
}
