package yangtz.cs.liu.campus.controller.schoolNewTeacherDzdn;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXprojectResearch;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteacherAwards;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXprojectResearchService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteachingAchievementsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXacademicWorksVo;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXprojectResearchVo;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 课题研究Controller
 *
 * @author ruoyi
 * @date 2023-12-13
 */
@RestController
@RequestMapping("/system/research")
public class SchoolXprojectResearchController extends BaseController {

    @Autowired
    private ISchoolXprojectResearchService schoolXprojectResearchService;
    @Autowired
    private ISchoolXteachingAchievementsService schoolXteachingAchievementsService;
    @Autowired
    private ISysDeptService sysDeptService;
    @Autowired
    private SchoolTeacherBasichlnformationService basichlnformationService;

    /**
     * 查询课题研究列表
     */
//    @PreAuthorize("@ss.hasPermi('system:research:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolXprojectResearchVo schoolXprojectResearchVo)
    {
        //过滤未提交的数据
        schoolXprojectResearchVo.setAuditState("0");

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            startPage();
            List<SchoolXprojectResearchVo> list = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
            return getDataTable(list);
        }

        //全部权限
        List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("ktyj_admin")).collect(Collectors.toList());
        if (roleList.size() > 0){
            startPage();
            List<SchoolXprojectResearchVo> list = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
            return getDataTable(list);
        }
        //部分权限
        List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
        //查询是否包含学科组长角色
        List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
        if (roleList1.size() > 0){
            //教师电子档案中级管理员只能查看本部门及部门以下的数据
            //根据用户部门id查询用户部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            //查询本部门下所有教师的id
            List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
            if (deptUserIds.size() > 0){
                schoolXprojectResearchVo.setUserIds(deptUserIds);
            }
            if (roleList2.size() > 0){
                //根据当前登陆人手机号查询任教学科
                String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                schoolXprojectResearchVo.setSub1(sub);
            }
            startPage();
            List<SchoolXprojectResearchVo> list = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
            return getDataTable(list);
        }
        if (roleList2.size() > 0){
            //根据当前登陆人手机号查询任教学科
            String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
            schoolXprojectResearchVo.setSub1(sub);
            startPage();
            List<SchoolXprojectResearchVo> list = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
            return getDataTable(list);
        }
        return getDataTable(new ArrayList<>());
    }

    /**
     * 查询课题研究列表(个人)
     */
//    @PreAuthorize("@ss.hasPermi('system:research:listGr')")
    @GetMapping("/listGr")
    public TableDataInfo listGr(SchoolXprojectResearchVo schoolXprojectResearchVo)
    {
        schoolXprojectResearchVo.setUserId(SecurityUtils.getUserId());
        startPage();
        List<SchoolXprojectResearchVo> list = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
        return getDataTable(list);
    }

    /**
     * 导出课题研究列表(个人)
     */
//    @PreAuthorize("@ss.hasPermi('system:research:exportGr')")
    @Log(title = "课题研究", businessType = BusinessType.EXPORT)
    @PostMapping("/exportGr")
    public void exportGr(HttpServletResponse response, SchoolXprojectResearchVo schoolXprojectResearchVo)
    {
        int i = 0;
        schoolXprojectResearchVo.setUserId(SecurityUtils.getUserId());
        List<SchoolXprojectResearchVo> list = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
        for (SchoolXprojectResearchVo xprojectResearchVo : list) {
            i ++;
            xprojectResearchVo.setXh(i);
            xprojectResearchVo.setGrowthType("课题研究");
        }
        ExcelUtil<SchoolXprojectResearchVo> util = new ExcelUtil<SchoolXprojectResearchVo>(SchoolXprojectResearchVo.class);
        util.exportExcel(response, list, "课题研究数据");
    }

    /**
     * 导出课题研究列表
     */
//    @PreAuthorize("@ss.hasPermi('system:research:export')")
    @Log(title = "课题研究", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolXprojectResearchVo schoolXprojectResearchVo)
    {
        int i = 0;
        //过滤未提交的数据
        schoolXprojectResearchVo.setAuditState("0");

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            List<SchoolXprojectResearchVo> list = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
            for (SchoolXprojectResearchVo xprojectResearchVo : list) {
                i ++;
                xprojectResearchVo.setXh(i);
                xprojectResearchVo.setGrowthType("课题研究");
            }
            ExcelUtil<SchoolXprojectResearchVo> util = new ExcelUtil<SchoolXprojectResearchVo>(SchoolXprojectResearchVo.class);
            util.exportExcel(response, list, "课题研究数据");
        }else {

            //全部权限
            List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("ktyj_admin")).collect(Collectors.toList());
            if (roleList.size() > 0){
                List<SchoolXprojectResearchVo> list = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
                for (SchoolXprojectResearchVo xprojectResearchVo : list) {
                    i ++;
                    xprojectResearchVo.setXh(i);
                    xprojectResearchVo.setGrowthType("课题研究");
                }
                ExcelUtil<SchoolXprojectResearchVo> util = new ExcelUtil<SchoolXprojectResearchVo>(SchoolXprojectResearchVo.class);
                util.exportExcel(response, list, "课题研究数据");
            }else {
                //部分权限
                List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
                //查询是否包含学科组长角色
                List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
                if (roleList1.size() > 0){
                    //教师电子档案中级管理员只能查看本部门及部门以下的数据
                    //根据用户部门id查询用户部门信息
                    SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
                    //查询本部门下所有教师的id
                    List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
                    if (deptUserIds.size() > 0){
                        schoolXprojectResearchVo.setUserIds(deptUserIds);
                    }
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolXprojectResearchVo.setSub1(sub);
                    }
                    List<SchoolXprojectResearchVo> list = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
                    for (SchoolXprojectResearchVo xprojectResearchVo : list) {
                        i ++;
                        xprojectResearchVo.setXh(i);
                        xprojectResearchVo.setGrowthType("课题研究");
                    }
                    ExcelUtil<SchoolXprojectResearchVo> util = new ExcelUtil<SchoolXprojectResearchVo>(SchoolXprojectResearchVo.class);
                    util.exportExcel(response, list, "课题研究数据");
                }else {
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolXprojectResearchVo.setSub1(sub);
                        List<SchoolXprojectResearchVo> list = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
                        for (SchoolXprojectResearchVo xprojectResearchVo : list) {
                            i ++;
                            xprojectResearchVo.setXh(i);
                            xprojectResearchVo.setGrowthType("课题研究");
                        }
                        ExcelUtil<SchoolXprojectResearchVo> util = new ExcelUtil<SchoolXprojectResearchVo>(SchoolXprojectResearchVo.class);
                        util.exportExcel(response, list, "课题研究数据");
                    }else {
                        ExcelUtil<SchoolXprojectResearchVo> util = new ExcelUtil<SchoolXprojectResearchVo>(SchoolXprojectResearchVo.class);
                        util.exportExcel(response, new ArrayList<>(), "课题研究数据");
                    }
                }
            }
        }

    }

    /**
     * 获取课题研究详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolXprojectResearchService.selectSchoolXprojectResearchById(id));
    }

    /**
     * 新增课题研究
     */
//    @PreAuthorize("@ss.hasPermi('system:research:add')")
    @Log(title = "课题研究", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolXprojectResearch schoolXprojectResearch)
    {
        return toAjax(schoolXprojectResearchService.insertSchoolXprojectResearch(schoolXprojectResearch));
    }

    /**
     * 修改课题研究
     */
//    @PreAuthorize("@ss.hasPermi('system:research:edit')")
    @Log(title = "课题研究", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolXprojectResearch schoolXprojectResearch)
    {
        return toAjax(schoolXprojectResearchService.updateSchoolXprojectResearch(schoolXprojectResearch));
    }

    /**
     * 删除课题研究
     */
//    @PreAuthorize("@ss.hasPermi('system:research:remove')")
    @Log(title = "课题研究", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolXprojectResearchService.deleteSchoolXprojectResearchByIds(ids));
    }

    /**
     * 审核
     */
//    @PreAuthorize("@ss.hasPermi('system:research:audit')")
    @PostMapping("/audit")
    public AjaxResult audit(@RequestBody SchoolXprojectResearch schoolXprojectResearch){
        return toAjax(schoolXprojectResearchService.audit(schoolXprojectResearch));
    }
}
