package yangtz.cs.liu.campus.controller.schoolNewTeacherDzdn;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXlectureAwards;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXlectureAwardsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteachingAchievementsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXlectureAwardsVo;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXteacherAwardsVo;

/**
 * 讲课获奖Controller
 *
 * @author ruoyi
 * @date 2023-12-06
 */
@RestController
@RequestMapping("/system/awards")
public class SchoolXlectureAwardsController extends BaseController
{
    @Autowired
    private ISchoolXlectureAwardsService schoolXlectureAwardsService;
    @Autowired
    private ISchoolXteachingAchievementsService schoolXteachingAchievementsService;
    @Autowired
    private ISysDeptService sysDeptService;
    @Autowired
    private SchoolTeacherBasichlnformationService basichlnformationService;

    /**
     * 查询讲课获奖列表
     */
//    @PreAuthorize("@ss.hasPermi('system:awards:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolXlectureAwardsVo schoolXlectureAwardsVo)
    {
        //过滤未提交的数据
        schoolXlectureAwardsVo.setAuditState("0");

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            startPage();
            List<SchoolXlectureAwardsVo> list = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
            return getDataTable(list);
        }
        //全部权限
        List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("jkhj_admin")).collect(Collectors.toList());
        if (roleList.size() > 0){
            startPage();
            List<SchoolXlectureAwardsVo> list = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
            return getDataTable(list);
        }
        //部分权限
        List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
        //查询是否包含学科组长角色
        List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
        if (roleList1.size() > 0){
            //教师电子档案中级管理员只能查看本部门及部门以下的数据
            //根据用户部门id查询用户部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            //查询本部门下所有教师的id
            List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
            if (deptUserIds.size() > 0){
                schoolXlectureAwardsVo.setUserIds(deptUserIds);
            }
            if (roleList2.size() > 0){
                //根据当前登陆人手机号查询任教学科
                String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                schoolXlectureAwardsVo.setSub1(sub);
            }
            startPage();
            List<SchoolXlectureAwardsVo> list = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
            return getDataTable(list);
        }
        if (roleList2.size() > 0){
            //根据当前登陆人手机号查询任教学科
            String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
            schoolXlectureAwardsVo.setSub1(sub);
            startPage();
            List<SchoolXlectureAwardsVo> list = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
            return getDataTable(list);
        }
        return getDataTable(new ArrayList<>());
    }

    /**
     * 查询讲课获奖列表(个人)
     */
//    @PreAuthorize("@ss.hasPermi('system:awards:listGr')")
    @GetMapping("/listGr")
    public TableDataInfo listGr(SchoolXlectureAwardsVo schoolXlectureAwardsVo)
    {
        schoolXlectureAwardsVo.setUserId(SecurityUtils.getUserId());
        startPage();
        List<SchoolXlectureAwardsVo> list = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
        return getDataTable(list);
    }

    /**
     * 导出讲课获奖列表(个人)
     */
//    @PreAuthorize("@ss.hasPermi('system:awards:exportGr')")
    @Log(title = "讲课获奖", businessType = BusinessType.EXPORT)
    @PostMapping("/exportGr")
    public void exportGr(HttpServletResponse response, SchoolXlectureAwardsVo schoolXlectureAwardsVo)
    {
        int i = 0;
        schoolXlectureAwardsVo.setUserId(SecurityUtils.getUserId());
        List<SchoolXlectureAwardsVo> list = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
        for (SchoolXlectureAwardsVo xlectureAwardsVo : list) {
            i ++;
            xlectureAwardsVo.setXh(i);
            xlectureAwardsVo.setGrowthType("讲课获奖");
        }
        ExcelUtil<SchoolXlectureAwardsVo> util = new ExcelUtil<SchoolXlectureAwardsVo>(SchoolXlectureAwardsVo.class);
        util.exportExcel(response, list, "讲课获奖数据");
    }

    /**
     * 导出讲课获奖列表
     */
//    @PreAuthorize("@ss.hasPermi('system:awards:export')")
    @Log(title = "讲课获奖", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolXlectureAwardsVo schoolXlectureAwardsVo)
    {
        int i = 0;
        //过滤未审核的数据
        schoolXlectureAwardsVo.setAuditState("0");

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            List<SchoolXlectureAwardsVo> list = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
            for (SchoolXlectureAwardsVo xlectureAwardsVo : list) {
                i ++;
                xlectureAwardsVo.setXh(i);
                xlectureAwardsVo.setGrowthType("讲课获奖");
            }
            ExcelUtil<SchoolXlectureAwardsVo> util = new ExcelUtil<SchoolXlectureAwardsVo>(SchoolXlectureAwardsVo.class);
            util.exportExcel(response, list, "讲课获奖数据");
        }else {

            //全部权限
            List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("jkhj_admin")).collect(Collectors.toList());
            if (roleList.size() > 0){
                List<SchoolXlectureAwardsVo> list = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
                for (SchoolXlectureAwardsVo xlectureAwardsVo : list) {
                    i ++;
                    xlectureAwardsVo.setXh(i);
                    xlectureAwardsVo.setGrowthType("讲课获奖");
                }
                ExcelUtil<SchoolXlectureAwardsVo> util = new ExcelUtil<SchoolXlectureAwardsVo>(SchoolXlectureAwardsVo.class);
                util.exportExcel(response, list, "讲课获奖数据");
            }else {
                //部分权限
                List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
                //查询是否包含学科组长角色
                List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
                if (roleList1.size() > 0){
                    //教师电子档案中级管理员只能查看本部门及部门以下的数据
                    //根据用户部门id查询用户部门信息
                    SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
                    //查询本部门下所有教师的id
                    List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
                    if (deptUserIds.size() > 0){
                        schoolXlectureAwardsVo.setUserIds(deptUserIds);
                    }
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolXlectureAwardsVo.setSub1(sub);
                    }
                    List<SchoolXlectureAwardsVo> list = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
                    for (SchoolXlectureAwardsVo xlectureAwardsVo : list) {
                        i ++;
                        xlectureAwardsVo.setXh(i);
                        xlectureAwardsVo.setGrowthType("讲课获奖");
                    }
                    ExcelUtil<SchoolXlectureAwardsVo> util = new ExcelUtil<SchoolXlectureAwardsVo>(SchoolXlectureAwardsVo.class);
                    util.exportExcel(response, list, "讲课获奖数据");
                }else {
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolXlectureAwardsVo.setSub1(sub);
                        List<SchoolXlectureAwardsVo> list = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
                        for (SchoolXlectureAwardsVo xlectureAwardsVo : list) {
                            i ++;
                            xlectureAwardsVo.setXh(i);
                            xlectureAwardsVo.setGrowthType("讲课获奖");
                        }
                        ExcelUtil<SchoolXlectureAwardsVo> util = new ExcelUtil<SchoolXlectureAwardsVo>(SchoolXlectureAwardsVo.class);
                        util.exportExcel(response, list, "讲课获奖数据");
                    }else {
                        ExcelUtil<SchoolXlectureAwardsVo> util = new ExcelUtil<SchoolXlectureAwardsVo>(SchoolXlectureAwardsVo.class);
                        util.exportExcel(response, new ArrayList<>(), "讲课获奖数据");
                    }
                }
            }
        }

    }

    /**
     * 获取讲课获奖详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolXlectureAwardsService.selectSchoolXlectureAwardsById(id));
    }

    /**
     * 新增讲课获奖
     */
//    @PreAuthorize("@ss.hasPermi('system:awards:add')")
    @Log(title = "讲课获奖", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolXlectureAwards schoolXlectureAwards)
    {
        return toAjax(schoolXlectureAwardsService.insertSchoolXlectureAwards(schoolXlectureAwards));
    }

    /**
     * 修改讲课获奖
     */
//    @PreAuthorize("@ss.hasPermi('system:awards:edit')")
    @Log(title = "讲课获奖", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolXlectureAwards schoolXlectureAwards)
    {
        return toAjax(schoolXlectureAwardsService.updateSchoolXlectureAwards(schoolXlectureAwards));
    }

    /**
     * 删除讲课获奖
     */
//    @PreAuthorize("@ss.hasPermi('system:awards:remove')")
    @Log(title = "讲课获奖", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolXlectureAwardsService.deleteSchoolXlectureAwardsByIds(ids));
    }

    /**
     * 审核
     */
//    @PreAuthorize("@ss.hasPermi('system:awards:audit')")
    @PostMapping("/audit")
    public AjaxResult audit(@RequestBody SchoolXlectureAwards schoolXlectureAwards){
        return toAjax(schoolXlectureAwardsService.audit(schoolXlectureAwards));
    }
}
