package yangtz.cs.liu.campus.controller.schoolNewTeacherDzdn;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXcomprehensiveHonors;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXcomprehensiveHonorsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteachingAchievementsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;
import yangtz.cs.liu.campus.vo.fudao.FudaoTeacherVo;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXcomprehensiveHonorsVo;

/**
 * 综合荣誉Controller
 *
 * @author ruoyi
 * @date 2023-12-06
 */
@RestController
@RequestMapping("/system/honors")
public class SchoolXcomprehensiveHonorsController extends BaseController
{
    @Autowired
    private ISchoolXcomprehensiveHonorsService schoolXcomprehensiveHonorsService;
    @Autowired
    private ISchoolXteachingAchievementsService schoolXteachingAchievementsService;
    @Autowired
    private ISysDeptService sysDeptService;
    @Autowired
    private SchoolTeacherBasichlnformationService basichlnformationService;

    /**
     * 查询综合荣誉列表
     */
//    @PreAuthorize("@ss.hasPermi('system:honors:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolXcomprehensiveHonorsVo schoolXcomprehensiveHonorsVo)
    {
        //过滤未提交的数据
        schoolXcomprehensiveHonorsVo.setAuditState("0");
        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            startPage();
            List<SchoolXcomprehensiveHonorsVo> list = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
            return getDataTable(list);
        }
        //全部权限
        List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("zhry_admin")).collect(Collectors.toList());
        if (roleList.size() > 0){
            startPage();
            List<SchoolXcomprehensiveHonorsVo> list = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
            return getDataTable(list);
        }
        //部分权限
        List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
        //查询是否包含学科组长角色
        List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
        if (roleList1.size() > 0){
            //教师电子档案中级管理员只能查看本部门及部门以下的数据
            //根据用户部门id查询用户部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            //查询本部门下所有教师的id
            List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
            if (deptUserIds.size() > 0){
                schoolXcomprehensiveHonorsVo.setUserIds(deptUserIds);
            }
            if (roleList2.size() > 0){
                //根据当前登陆人手机号查询任教学科
                String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                schoolXcomprehensiveHonorsVo.setSub1(sub);
            }
            startPage();
            List<SchoolXcomprehensiveHonorsVo> list = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
            return getDataTable(list);
        }
        if (roleList2.size() > 0){
            //根据当前登陆人手机号查询任教学科
            String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
            schoolXcomprehensiveHonorsVo.setSub1(sub);
            startPage();
            List<SchoolXcomprehensiveHonorsVo> list = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
            return getDataTable(list);
        }
        return getDataTable(new ArrayList<>());
    }

    /**
     * 查询综合荣誉列表(个人)
     */
//    @PreAuthorize("@ss.hasPermi('system:honors:listGr')")
    @GetMapping("/listGr")
    public TableDataInfo listGr(SchoolXcomprehensiveHonorsVo schoolXcomprehensiveHonorsVo)
    {
        schoolXcomprehensiveHonorsVo.setUserId(SecurityUtils.getUserId());
        startPage();
        List<SchoolXcomprehensiveHonorsVo> list = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
        return getDataTable(list);
    }

    /**
     * 导出综合荣誉列表(个人)
     */
//    @PreAuthorize("@ss.hasPermi('system:honors:exportGr')")
    @Log(title = "综合荣誉", businessType = BusinessType.EXPORT)
    @PostMapping("/exportGr")
    public void exportGr(HttpServletResponse response, SchoolXcomprehensiveHonorsVo schoolXcomprehensiveHonorsVo)
    {
        int i = 0;
        schoolXcomprehensiveHonorsVo.setUserId(SecurityUtils.getUserId());
        List<SchoolXcomprehensiveHonorsVo> list = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
        for (SchoolXcomprehensiveHonorsVo xcomprehensiveHonorsVo : list) {
            i ++;
            xcomprehensiveHonorsVo.setXh(i);
            xcomprehensiveHonorsVo.setGrowthType("综合荣誉");
        }
        ExcelUtil<SchoolXcomprehensiveHonorsVo> util = new ExcelUtil<SchoolXcomprehensiveHonorsVo>(SchoolXcomprehensiveHonorsVo.class);
        util.exportExcel(response, list, "综合荣誉数据");
    }

    /**
     * 导出综合荣誉列表
     */
//    @PreAuthorize("@ss.hasPermi('system:honors:export')")
    @Log(title = "综合荣誉", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolXcomprehensiveHonorsVo schoolXcomprehensiveHonorsVo)
    {
        int i = 0;
        //过滤未提交的数据
        schoolXcomprehensiveHonorsVo.setAuditState("0");

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            List<SchoolXcomprehensiveHonorsVo> list = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
            for (SchoolXcomprehensiveHonorsVo xcomprehensiveHonorsVo : list) {
                i ++;
                xcomprehensiveHonorsVo.setXh(i);
                xcomprehensiveHonorsVo.setGrowthType("综合荣誉");
            }
            ExcelUtil<SchoolXcomprehensiveHonorsVo> util = new ExcelUtil<SchoolXcomprehensiveHonorsVo>(SchoolXcomprehensiveHonorsVo.class);
            util.exportExcel(response, list, "综合荣誉数据");
        }else {

            //全部权限
            List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("zhry_admin")).collect(Collectors.toList());
            if (roleList.size() > 0){
                List<SchoolXcomprehensiveHonorsVo> list = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
                for (SchoolXcomprehensiveHonorsVo xcomprehensiveHonorsVo : list) {
                    i ++;
                    xcomprehensiveHonorsVo.setXh(i);
                    xcomprehensiveHonorsVo.setGrowthType("综合荣誉");
                }
                ExcelUtil<SchoolXcomprehensiveHonorsVo> util = new ExcelUtil<SchoolXcomprehensiveHonorsVo>(SchoolXcomprehensiveHonorsVo.class);
                util.exportExcel(response, list, "综合荣誉数据");
            }else {
                //部分权限
                List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
                //查询是否包含学科组长角色
                List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
                if (roleList1.size() > 0){
                    //教师电子档案中级管理员只能查看本部门及部门以下的数据
                    //根据用户部门id查询用户部门信息
                    SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
                    //查询本部门下所有教师的id
                    List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
                    if (deptUserIds.size() > 0){
                        schoolXcomprehensiveHonorsVo.setUserIds(deptUserIds);
                    }
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolXcomprehensiveHonorsVo.setSub1(sub);
                    }
                    List<SchoolXcomprehensiveHonorsVo> list = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
                    for (SchoolXcomprehensiveHonorsVo xcomprehensiveHonorsVo : list) {
                        i ++;
                        xcomprehensiveHonorsVo.setXh(i);
                        xcomprehensiveHonorsVo.setGrowthType("综合荣誉");
                    }
                    ExcelUtil<SchoolXcomprehensiveHonorsVo> util = new ExcelUtil<SchoolXcomprehensiveHonorsVo>(SchoolXcomprehensiveHonorsVo.class);
                    util.exportExcel(response, list, "综合荣誉数据");
                }else {
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolXcomprehensiveHonorsVo.setSub1(sub);
                        List<SchoolXcomprehensiveHonorsVo> list = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
                        for (SchoolXcomprehensiveHonorsVo xcomprehensiveHonorsVo : list) {
                            i ++;
                            xcomprehensiveHonorsVo.setXh(i);
                            xcomprehensiveHonorsVo.setGrowthType("综合荣誉");
                        }
                        ExcelUtil<SchoolXcomprehensiveHonorsVo> util = new ExcelUtil<SchoolXcomprehensiveHonorsVo>(SchoolXcomprehensiveHonorsVo.class);
                        util.exportExcel(response, list, "综合荣誉数据");
                    }else {
                        ExcelUtil<SchoolXcomprehensiveHonorsVo> util = new ExcelUtil<SchoolXcomprehensiveHonorsVo>(SchoolXcomprehensiveHonorsVo.class);
                        util.exportExcel(response, new ArrayList<>(), "综合荣誉数据");
                    }
                }

            }

        }
    }

    /**
     * 获取综合荣誉详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsById(id));
    }

    /**
     * 新增综合荣誉
     */
//    @PreAuthorize("@ss.hasPermi('system:honors:add')")
    @Log(title = "综合荣誉", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolXcomprehensiveHonors schoolXcomprehensiveHonors)
    {
        return toAjax(schoolXcomprehensiveHonorsService.insertSchoolXcomprehensiveHonors(schoolXcomprehensiveHonors));
    }

    /**
     * 修改综合荣誉
     */
//    @PreAuthorize("@ss.hasPermi('system:honors:edit')")
    @Log(title = "综合荣誉", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolXcomprehensiveHonors schoolXcomprehensiveHonors)
    {
        return toAjax(schoolXcomprehensiveHonorsService.updateSchoolXcomprehensiveHonors(schoolXcomprehensiveHonors));
    }

    /**
     * 删除综合荣誉
     */
//    @PreAuthorize("@ss.hasPermi('system:honors:remove')")
    @Log(title = "综合荣誉", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolXcomprehensiveHonorsService.deleteSchoolXcomprehensiveHonorsByIds(ids));
    }

    /**
     * 审核
     */
//    @PreAuthorize("@ss.hasPermi('system:honors:audit')")
    @PostMapping("/audit")
    public AjaxResult audit(@RequestBody SchoolXcomprehensiveHonors schoolXcomprehensiveHonors){
        return toAjax(schoolXcomprehensiveHonorsService.audit(schoolXcomprehensiveHonors));
    }
}
