package yangtz.cs.liu.campus.controller.schoolNewTeacherDzdn;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysDeptService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXacademicWorks;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXacademicWorksService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteachingAchievementsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXacademicWorksVo;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXlectureAwardsVo;

/**
 * 论文著作Controller
 *
 * @author ruoyi
 * @date 2023-12-06
 */
@RestController
@RequestMapping("/system/works")
public class SchoolXacademicWorksController extends BaseController
{
    @Autowired
    private ISchoolXacademicWorksService schoolXacademicWorksService;
    @Autowired
    private ISchoolXteachingAchievementsService schoolXteachingAchievementsService;
    @Autowired
    private ISysDeptService sysDeptService;
    @Autowired
    private SchoolTeacherBasichlnformationService basichlnformationService;

    /**
     * 查询论文著作列表
     */
//    @PreAuthorize("@ss.hasPermi('system:works:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolXacademicWorksVo schoolXacademicWorksVo)
    {
        //过滤未提交的数据
        schoolXacademicWorksVo.setAuditState("0");

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            startPage();
            List<SchoolXacademicWorksVo> list = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
            return getDataTable(list);
        }
        //全部权限
        List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("lwlz_admin")).collect(Collectors.toList());
        if (roleList.size() > 0){
            startPage();
            List<SchoolXacademicWorksVo> list = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
            return getDataTable(list);
        }
        //部分权限
        List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
        //查询是否包含学科组长角色
        List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
        if (roleList1.size() > 0){
            //教师电子档案中级管理员只能查看本部门及部门以下的数据
            //根据用户部门id查询用户部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
            if (deptUserIds.size() > 0){
                schoolXacademicWorksVo.setUserIds(deptUserIds);
            }
            if (roleList2.size() > 0){
                //根据当前登陆人手机号查询任教学科
                String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                schoolXacademicWorksVo.setSub1(sub);
            }
            startPage();
            List<SchoolXacademicWorksVo> list = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
            return getDataTable(list);
        }
        if (roleList2.size() > 0){
            //根据当前登陆人手机号查询任教学科
            String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
            schoolXacademicWorksVo.setSub1(sub);
            startPage();
            List<SchoolXacademicWorksVo> list = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
            return getDataTable(list);
        }
        return getDataTable(new ArrayList<>());
    }

    /**
     * 查询论文著作列表(个人)
     */
//    @PreAuthorize("@ss.hasPermi('system:works:listGr')")
    @GetMapping("/listGr")
    public TableDataInfo listGr(SchoolXacademicWorksVo schoolXacademicWorksVo)
    {
        schoolXacademicWorksVo.setUserId(SecurityUtils.getUserId());
        startPage();
        List<SchoolXacademicWorksVo> list = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
        return getDataTable(list);
    }

    /**
     * 导出论文著作列表(个人)
     */
//    @PreAuthorize("@ss.hasPermi('system:works:exportGr')")
    @Log(title = "论文著作", businessType = BusinessType.EXPORT)
    @PostMapping("/exportGr")
    public void exportGr(HttpServletResponse response, SchoolXacademicWorksVo schoolXacademicWorksVo)
    {
        int i = 0;
        schoolXacademicWorksVo.setUserId(SecurityUtils.getUserId());
        List<SchoolXacademicWorksVo> list = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
        for (SchoolXacademicWorksVo xacademicWorksVo : list) {
            i ++;
            xacademicWorksVo.setXh(i);
            xacademicWorksVo.setGrowthType("论文论著");
        }
        ExcelUtil<SchoolXacademicWorksVo> util = new ExcelUtil<SchoolXacademicWorksVo>(SchoolXacademicWorksVo.class);
        util.exportExcel(response, list, "论文著作数据");
    }

    /**
     * 导出论文著作列表
     */
//    @PreAuthorize("@ss.hasPermi('system:works:export')")
    @Log(title = "论文著作", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolXacademicWorksVo schoolXacademicWorksVo)
    {
        int i = 0;
        //过滤未提交的数据
        schoolXacademicWorksVo.setAuditState("0");

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            List<SchoolXacademicWorksVo> list = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
            for (SchoolXacademicWorksVo xacademicWorksVo : list) {
                i ++;
                xacademicWorksVo.setXh(i);
                xacademicWorksVo.setGrowthType("论文论著");
            }
            ExcelUtil<SchoolXacademicWorksVo> util = new ExcelUtil<SchoolXacademicWorksVo>(SchoolXacademicWorksVo.class);
            util.exportExcel(response, list, "论文著作数据");
        }else {

            //全部权限
            List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("lwlz_admin")).collect(Collectors.toList());
            if (roleList.size() > 0){
                List<SchoolXacademicWorksVo> list = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
                for (SchoolXacademicWorksVo xacademicWorksVo : list) {
                    i ++;
                    xacademicWorksVo.setXh(i);
                    xacademicWorksVo.setGrowthType("论文论著");
                }
                ExcelUtil<SchoolXacademicWorksVo> util = new ExcelUtil<SchoolXacademicWorksVo>(SchoolXacademicWorksVo.class);
                util.exportExcel(response, list, "论文著作数据");
            }else {
                //部分权限
                List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
                //查询是否包含学科组长角色
                List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
                if (roleList1.size() > 0){
                    //教师电子档案中级管理员只能查看本部门及部门以下的数据
                    //根据用户部门id查询用户部门信息
                    SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
                    //查询本部门下所有教师的id
                    List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
                    if (deptUserIds.size() > 0){
                        schoolXacademicWorksVo.setUserIds(deptUserIds);
                    }
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolXacademicWorksVo.setSub1(sub);
                    }
                    List<SchoolXacademicWorksVo> list = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
                    for (SchoolXacademicWorksVo xacademicWorksVo : list) {
                        i ++;
                        xacademicWorksVo.setXh(i);
                        xacademicWorksVo.setGrowthType("论文论著");
                    }
                    ExcelUtil<SchoolXacademicWorksVo> util = new ExcelUtil<SchoolXacademicWorksVo>(SchoolXacademicWorksVo.class);
                    util.exportExcel(response, list, "论文著作数据");
                }else {
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolXacademicWorksVo.setSub1(sub);
                        List<SchoolXacademicWorksVo> list = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
                        for (SchoolXacademicWorksVo xacademicWorksVo : list) {
                            i ++;
                            xacademicWorksVo.setXh(i);
                            xacademicWorksVo.setGrowthType("论文论著");
                        }
                        ExcelUtil<SchoolXacademicWorksVo> util = new ExcelUtil<SchoolXacademicWorksVo>(SchoolXacademicWorksVo.class);
                        util.exportExcel(response, list, "论文著作数据");
                    }else {
                        ExcelUtil<SchoolXacademicWorksVo> util = new ExcelUtil<SchoolXacademicWorksVo>(SchoolXacademicWorksVo.class);
                        util.exportExcel(response, new ArrayList<>(), "论文著作数据");
                    }
                }
            }
        }
    }

    /**
     * 获取论文著作详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolXacademicWorksService.selectSchoolXacademicWorksById(id));
    }

    /**
     * 新增论文著作
     */
//    @PreAuthorize("@ss.hasPermi('system:works:add')")
    @Log(title = "论文著作", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolXacademicWorks schoolXacademicWorks)
    {
        return toAjax(schoolXacademicWorksService.insertSchoolXacademicWorks(schoolXacademicWorks));
    }

    /**
     * 修改论文著作
     */
//    @PreAuthorize("@ss.hasPermi('system:works:edit')")
    @Log(title = "论文著作", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolXacademicWorks schoolXacademicWorks)
    {
        return toAjax(schoolXacademicWorksService.updateSchoolXacademicWorks(schoolXacademicWorks));
    }

    /**
     * 删除论文著作
     */
//    @PreAuthorize("@ss.hasPermi('system:works:remove')")
    @Log(title = "论文著作", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolXacademicWorksService.deleteSchoolXacademicWorksByIds(ids));
    }

    /**
     * 审核
     */
//    @PreAuthorize("@ss.hasPermi('system:works:audit')")
    @PostMapping("/audit")
    public AjaxResult audit(@RequestBody SchoolXacademicWorks schoolXacademicWorks){
        return toAjax(schoolXacademicWorksService.audit(schoolXacademicWorks));
    }
}
