package yangtz.cs.liu.campus.controller.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.ruoyi.common.config.RuoYiConfig;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.pdf.PDFUtil;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysDeptService;
import com.ruoyi.system.service.ISysUserService;
import com.ruoyi.system.service.impl.SysDictDataServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolAnnualAssessment.SchoolAnnualAssessment;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.*;
import yangtz.cs.liu.campus.service.impl.teacherFiles.IdCardNumberUtils;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteachingAchievementsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;
import yangtz.cs.liu.campus.vo.fudao.FudaoStudentVo;
import yangtz.cs.liu.campus.vo.fudao.FudaoTeacherVo;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXteachingAchievementsVo;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/teacher/basiclnformation")
public class SchoolTeacherBasiclnformationController extends BaseController {

    private Logger log = LoggerFactory.getLogger(SchoolTeacherBasiclnformationController.class);

    @Autowired
    private SchoolTeacherBasichlnformationService basichlnformationService;

    @Autowired
    private SysDictDataServiceImpl sysDictDataService;
    @Autowired
    private ISchoolXteachingAchievementsService schoolXteachingAchievementsService;
    @Autowired
    private ISysDeptService sysDeptService;

    /**
     * 获取老师基本信息列表
     * @param information
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherBasicInformationVo information) throws  Exception{

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()){
            startPage();
            List<SchoolTeacherBasicInformationVo> list = basichlnformationService.list(information);
            return getDataTable(list);
        }

        List<SysRole> sysRoles = roles.stream().filter(item -> item.getRoleKey().equals("jsdzdncj_admin") || item.getRoleKey().equals("jsjcxj_admin")).collect(Collectors.toList());
        //全部权限
        if(sysRoles.size()>0){
            startPage();
            List<SchoolTeacherBasicInformationVo> list = basichlnformationService.list(information);
            return getDataTable(list);
        }
        //部分权限
        List<SysRole> sysRoles2 = roles.stream().filter(item -> item.getRoleKey().equals("jsdnzj_admin") ).collect(Collectors.toList());
        //查询是否包含学科组长角色
        List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
        if(sysRoles2.size()>0){
            //教师电子档案中级管理员只能看本部门及以下的数据
            //获取当前登陆人的部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            //获取当前登陆人部门下所有人的手机号
            List<String> userPhones = schoolXteachingAchievementsService.getUserPhonesByDeptId(sysDept.getDeptId());
            if (userPhones.size() > 0){
                information.setUserPhones(userPhones);
            }
            if (roleList2.size() > 0){
                //根据当前登陆人手机号查询任教学科
                String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                information.setTeachingSubject1(sub);
            }
            startPage();
            List<SchoolTeacherBasicInformationVo> list = basichlnformationService.list(information);
            return getDataTable(list);
        }
        if (roleList2.size() > 0){
            //根据当前登陆人手机号查询任教学科
            String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
            information.setTeachingSubject1(sub);
            startPage();
            List<SchoolTeacherBasicInformationVo> list = basichlnformationService.list(information);
            return getDataTable(list);
        }
        return getDataTable(new ArrayList<>());
    }

    /**
     * 获取详情
     */
    @GetMapping("/{id}")
    public AjaxResult getById(@PathVariable("id") Long id ) throws Exception{
        return AjaxResult.success(basichlnformationService.getByIds(id));
    }

    /**
     * 新增老师信息
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolTeacherBasicInformation information){

        //1.验证身份证信息是否重复
        String idCard = information.getIdCard();
        LambdaQueryWrapper<SchoolTeacherBasicInformation> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SchoolTeacherBasicInformation::getDelFlag,"0");
        LambdaQueryWrapper<SchoolTeacherBasicInformation> eq = wrapper.eq(SchoolTeacherBasicInformation::getIdCard, idCard);
        List<SchoolTeacherBasicInformation> list = basichlnformationService.list(eq);
        if (!list.isEmpty()){
            return AjaxResult.error(
                    information.getName()+"人员身份证已经存在,身份证重复信息不可录入");
        }
        //出生年月日获取
        String birthDayFromIdCard = IdCardNumberUtils.getBirthDayFromIdCard(information.getIdCard());
        information.setBirthDate(birthDayFromIdCard);
        //性别获取
        Map<String, Object> sexFromIdCard = IdCardNumberUtils.getSexFromIdCard(information.getIdCard());
        Integer sex = (Integer) sexFromIdCard.get(IdCardNumberUtils.SEX_BY_INT_MAP_KEY);
        if (null == sex){
            return AjaxResult.error("请输入正确的身份证号");
        }
        if (sex == 1){
            information.setSex("0");
        }else {
            information.setSex("1");
        }
        return AjaxResult.success(basichlnformationService.save(information));
    }

    /**
     * 修改老师信息
     */
    @PutMapping("/update")
    public AjaxResult update(@RequestBody SchoolTeacherBasicInformation information){

        return AjaxResult.success(basichlnformationService.updateInformationById(information));
    }

    /**
     * 删除信息
     */
    @DeleteMapping("/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids){
        List<Long> list = Arrays.asList(ids);
        boolean b = basichlnformationService.removeByIds(list);
        return AjaxResult.success(b);
    }

    @PostMapping(value = "/download")
    public void downloadFile(HttpServletResponse response) throws Exception {
        // 以流的形式下载文件。
        try {
            //读取文件
            InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("file/教师基础信息导入模板.xlsx");
            InputStream fis = new BufferedInputStream(resourceAsStream);
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();
            // 设置response的Header
            response.setHeader("Content-Disposition", "attachment;filename="+java.net.URLEncoder.encode("教师基础信息导入模板.xlsx", "utf-8"));
            //response.addHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes()));
            response.addHeader("Content-Length", "" + buffer.length);
            OutputStream toClient = new BufferedOutputStream(response.getOutputStream());
            response.setContentType("application/octet-stream");
            toClient.write(buffer);
            toClient.flush();
            toClient.close();
        } catch (IOException e) {
            log.info(e.getMessage());
        }
    }

    /**
     * 导入
     *
     * @param file
     * @return
     * @throws Exception
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file) throws Exception {
        ExcelUtil<SchoolTeacherBasicInformation> util = new ExcelUtil<SchoolTeacherBasicInformation>(SchoolTeacherBasicInformation.class);
        List<SchoolTeacherBasicInformation> schoolTeacherBasicInformations = util.importExceltoRow(file.getInputStream(),1);
        return  basichlnformationService.saveOrUpdateList(schoolTeacherBasicInformations);
    }


    /**
     * 导出
     *
     * @param
     * @return
     */
   @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolTeacherBasicInformationVo export ) throws Exception{

       //获取当前登陆人信息
       SysUser user = SecurityUtils.getLoginUser().getUser();
       //获取当前登陆人的角色信息
       List<SysRole> roles = user.getRoles();
       if (user.isAdmin()){
           List<SchoolTeacherBasicInformationVo> list1 = basichlnformationService.list(export);
           ExcelUtil<SchoolTeacherBasicInformationVo> util = new ExcelUtil<>(SchoolTeacherBasicInformationVo.class);
           util.exportExcel(response, list1, "教师基本信息");
       }else{

           List<SysRole> sysRoles = roles.stream().filter(item -> item.getRoleKey().equals("jsdzdncj_admin") || item.getRoleKey().equals("jsjcxj_admin")).collect(Collectors.toList());
           //全部权限
           if(sysRoles.size()>0){
               List<SchoolTeacherBasicInformationVo> list1 = basichlnformationService.list(export);
               ExcelUtil<SchoolTeacherBasicInformationVo> util = new ExcelUtil<>(SchoolTeacherBasicInformationVo.class);
               util.exportExcel(response, list1, "教师基本信息");
           }else {
               //部分权限
               List<SysRole> sysRoles2 = roles.stream().filter(item -> item.getRoleKey().equals("jsdnzj_admin") ).collect(Collectors.toList());
               //查询是否包含学科组长角色
               List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
               if(sysRoles2.size()>0){
                   //教师电子档案中级管理员只能看本部门及以下的数据
                   //获取当前登陆人的部门信息
                   SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
                   //获取当前登陆人部门下所有人的身份证号
                   List<String> userPhones = schoolXteachingAchievementsService.getUserPhonesByDeptId(sysDept.getDeptId());
                   if (userPhones.size() > 0){
                       export.setUserPhones(userPhones);
                   }
                   if (roleList2.size() > 0){
                       //根据当前登陆人手机号查询任教学科
                       String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                       export.setTeachingSubject1(sub);
                   }
                   List<SchoolTeacherBasicInformationVo> list1 = basichlnformationService.list(export);
                   ExcelUtil<SchoolTeacherBasicInformationVo> util = new ExcelUtil<>(SchoolTeacherBasicInformationVo.class);
                   util.exportExcel(response, list1, "教师基本信息");
               }else {
                   if (roleList2.size() > 0){
                       //根据当前登陆人手机号查询任教学科
                       String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                       export.setTeachingSubject1(sub);
                       List<SchoolTeacherBasicInformationVo> list1 = basichlnformationService.list(export);
                       ExcelUtil<SchoolTeacherBasicInformationVo> util = new ExcelUtil<>(SchoolTeacherBasicInformationVo.class);
                       util.exportExcel(response, list1, "教师基本信息");
                   }  else {
                       ExcelUtil<SchoolTeacherBasicInformationVo> util = new ExcelUtil<>(SchoolTeacherBasicInformationVo.class);
                       util.exportExcel(response, new ArrayList<>(), "教师基本信息");
                   }
               }
           }
       }
    }


    /*
     * 批量导入老师照片
     * */
    @PostMapping("/importTeacherPicture")
    public AjaxResult importTeacherPicture(MultipartFile file){
        return AjaxResult.success(basichlnformationService.importTeacherPicture(file));
    }

    /**
     * 综合查询
     */
    @GetMapping("/comprehensive")
    public  AjaxResult comprehensive(ComprehensiveReq req) throws Exception{
        ComperhensiveVo comprehensive = basichlnformationService.comprehensive(req);
        return  AjaxResult.success(comprehensive);
    }
    @Autowired
    private ISysUserService userService;

    /**
     * 老师个人综合查询
     */
    @GetMapping("/compre/{phoneNumber}")
    public  AjaxResult comprehensiveByPhoneNumber(@PathVariable("phoneNumber") String phoneNumber) throws Exception{
        ComperhensiveVo comprehensive = basichlnformationService.comprehensiveByPhoneNumber(phoneNumber);
        return  AjaxResult.success(comprehensive);
    }

    /**
     * pdf导出
     */
    @PostMapping("/exportPDF")
    public void exportPdf(HttpServletResponse response,ComprehensiveReq req) throws  Exception{
        ComperhensiveVo comprehensive = null;
        if (StringUtils.isNotEmpty(req.getPhoneNumber())){
            comprehensive = basichlnformationService.comprehensiveByPhoneNumber(req.getPhoneNumber());

        }else {
             comprehensive = basichlnformationService.comprehensive(req);

        }
        if (comprehensive==null){
            throw  new RuntimeException("当前用户未找到教师基本信息，请完善教师基本信息");
        }
        SchoolTeacherBasicInformationVo basicInformation = comprehensive.getBasicInformation();
        try {
            //创建文档
            Document document = PDFUtil.createDocument();
            //通过文档获取输出流
            ByteArrayOutputStream outStream = PDFUtil.getOutStream(document);
            //打开文档，准备后续添加内容
            document.open();
            //设置基础字体格式
            BaseFont baseFont = PDFUtil.getBaseFont(PDFUtil.FONT_SONG, PDFUtil.BASE_FONT_CHINESE_ENCODING, Boolean.FALSE);
            //设置标题
            Chunk chunk = PDFUtil.getChunk("教师个人信息汇总", PDFUtil.getFont(baseFont, 20, Font.NORMAL));
            Paragraph titleParagraph = PDFUtil.getParagraph(chunk, Element.ALIGN_CENTER, 20, null);
            document.add(titleParagraph);
            //创建表格(具体样式需要根据生成的PDF去调整)
            PdfPTable pdfPTable = PDFUtil.getPdfPTable(8, 100, 1500);


            Font font = PDFUtil.getFont(baseFont, 12, Font.NORMAL);
            font.setStyle(Font.BOLD);
            Chunk qtchunk = PDFUtil.getChunk("教师基本信息", font);
            Paragraph qtParagraph = PDFUtil.getParagraph(qtchunk, Element.ALIGN_LEFT, 0, null);
            qtParagraph.setSpacingAfter(5f);
            qtParagraph.setLeading(15f); //行间距
            qtParagraph.setSpacingBefore(10f); //设置段落上空白
            document.add(qtParagraph);

            //创建单元格对象
            PdfPCell pdfCell = PDFUtil.getPdfCell(null, Element.ALIGN_CENTER, Element.ALIGN_MIDDLE, null, Boolean.TRUE);
            //此后代码开始设置值，会自动渲染到表格中，无需考虑换行问题
            //设置单元格字体样式
            Font cellFont = PDFUtil.getFont(baseFont, 8, Font.NORMAL);
            cellFont.setStyle(Font.BOLD);
            Font cellcoentFont = PDFUtil.getFont(baseFont, 7, Font.NORMAL);
            //第一行
            PDFUtil.addPdfPTitleCell("姓名", cellFont, pdfCell, pdfPTable, 20);
            //合并第一行2-4个单元格
            PDFUtil.addPdfPCell(basicInformation.getName(), cellcoentFont, pdfCell, pdfPTable, 20);

            //第二行
            PDFUtil.addPdfPTitleCell("性别", cellFont, pdfCell, pdfPTable, 20);
            //合并第二行2-4单元格
            PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("sys_user_sex",basicInformation.getSex()), cellcoentFont, pdfCell, pdfPTable, 20);

            //第三行
            PDFUtil.addPdfPTitleCell("年龄", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getAge().toString(), cellcoentFont, pdfCell, pdfPTable, 20);

            //测试图片
//            Image img = Image.getInstance("https://img.dahepiao.com/uploads/allimg/191010/10540H550-0.jpg");
            //获取图片 /profile
            Image img = null;
            if (StringUtils.isNotEmpty(basicInformation.getPhotoUrl())){
                String substring = basicInformation.getPhotoUrl().substring(15, basicInformation.getPhotoUrl().length());
                String filePath = RuoYiConfig.getAvatarPath() + substring;
                img = Image.getInstance(filePath);
                 //图片格式转换
                img.setAlignment(Element.ALIGN_CENTER);
            }

            Font sonTitleFont = PDFUtil.getFont(baseFont, 11, Font.BOLD);
            PdfPCell nameplateCell = PDFUtil.getColSpanPdfCell(PDFUtil.getPhrase(" 照片 ", sonTitleFont),
                    Element.ALIGN_CENTER, Element.ALIGN_MIDDLE, 15, Boolean.TRUE, 2,6);
            nameplateCell.setImage(img);
            pdfPTable.addCell(nameplateCell);

            PDFUtil.addPdfPTitleCell("出生年月", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getBirthDate(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("籍贯", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getHometown(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("民族", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getNation(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("身份证号", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getIdCard(), cellcoentFont, pdfCell, pdfPTable, 20);


            PDFUtil.addPdfPTitleCell("档案出生年月", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell( dateConversionString(basicInformation.getFileBirthDate()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("政治面貌", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("politics_tatusls",basicInformation.getPoliticalLandscape()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("入党时间", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(dateConversionString(basicInformation.getPartyMembershipTime()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("任教学科", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("sub_dzdn",basicInformation.getTeachingSubject()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("现职称", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("current_professional",basicInformation.getCurrentProfessionalTitle()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("现职称取得资格时间", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(dateConversionString(basicInformation.getCurrentProfessionalTitleTime()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("现聘职称", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("current_professional",basicInformation.getCurrentHiringProfessionalTitle()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("现职称聘任时间", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(dateConversionString(basicInformation.getCurrentHiringProfessionalTitleTime()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("现聘岗位", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("current_position",basicInformation.getCurrentPosition()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("现岗位等级", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("current_joblevel",basicInformation.getCurrentJobLevel()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("现岗位等级聘任时间", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(dateConversionString(basicInformation.getCurrentJobLevelAppointmentTime()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("职务", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getDuties(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("教师资格种类", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getTeacherQualificationType(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("教师资格证号码", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getTeacherQualificationCertificateNum(), cellcoentFont, pdfCell, pdfPTable, 20);


            PDFUtil.addPdfPTitleCell("参加工作时间", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getWorkingHours(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("到二中工作时间", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(dateConversionString(basicInformation.getToSecondMiddleSchoolTime()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("二中工作年龄", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getToSecondAge().toString(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("教龄起算时间", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(dateConversionString(basicInformation.getLengthOfTeacherTime()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("工龄起算时间", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(dateConversionString(basicInformation.getLengthOfTeacherTime()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("工龄年限", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(isNotString(basicInformation.getSeniority()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("在岗情况", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("current_situation",basicInformation.getOnDutySituation()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("在编情况", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("current_situation",basicInformation.getCurrentSituation()), cellcoentFont, pdfCell, pdfPTable, 20);


            PDFUtil.addPdfPTitleCell("毕业学院1", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getGraduationInstitution1(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("专业1", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getMajor1(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("毕业时间1", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(dateConversionString(basicInformation.getGraduationTime1()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("毕业学院2", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getGraduationInstitution2(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("专业2", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getMajor2(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("毕业时间2", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(dateConversionString(basicInformation.getGraduationTime2()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("毕业学院3", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getGraduationInstitution3(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("专业3", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getMajor3(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("毕业时间3", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(dateConversionString(basicInformation.getGraduationTime3()), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("第一学历", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getFirstDegree(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("最后学历", cellFont, pdfCell, pdfPTable, 20);
            PDFUtil.addPdfPCell(basicInformation.getLastDegree(), cellcoentFont, pdfCell, pdfPTable, 20);

            PDFUtil.addPdfPTitleCell("学位", cellFont, pdfCell, pdfPTable, 20);
//            PDFUtil.addPdfPCell(basicInformation.getDegree(), cellcoentFont, pdfCell, pdfPTable, 20);
            PdfPCell xueweititle = PDFUtil.getColSpanPdfCell(PDFUtil.getPhrase(basicInformation.getDegree(), cellcoentFont),
                    Element.ALIGN_CENTER, Element.ALIGN_MIDDLE, 15, Boolean.TRUE, 3,0);
            pdfPTable.addCell(xueweititle);

            //将表格添加至文中
            document.add(pdfPTable);

            //2.表格 工作量信息
            PdfPTable pdfPTablegz = PDFUtil.getPdfPTable(16, 100, 1500);
            Chunk qtchunkgz = PDFUtil.getChunk("工作量信息",font);
            Paragraph qtParagraphgz = PDFUtil.getParagraph(qtchunkgz, Element.ALIGN_LEFT, 0, null);
            qtParagraphgz.setSpacingAfter(5f);
            qtParagraphgz.setLeading(15f); //行间距
            qtParagraphgz.setSpacingBefore(10f); //设置段落上空白
            document.add(qtParagraphgz);

            List<SchoolAworkloadVo> schoolAworkload = comprehensive.getSchoolAworkload();
            PDFUtil.addPdfPTitleCell("学年", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("学期", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("届别", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("年级", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("姓名", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("学科", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("聘任岗位", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("聘任职务", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("聘任情况", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("班级", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("班级类型", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("早读", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("正课", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("晚自习", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("合计", cellFont, pdfCell, pdfPTablegz, 20);
            PDFUtil.addPdfPTitleCell("证明人", cellFont, pdfCell, pdfPTablegz, 20);
            for (SchoolAworkloadVo date: schoolAworkload){
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("yearda",date.getSchoolYear()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("semester_jsdzda",date.getSemester()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("rankda",date.getYear()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("grade_da",date.getGrade()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(date.getName(), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("sub_dzdn",date.getSub()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("appointment_positions",date.getAppointmentPost()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(date.getAppointmentPosition(), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("appointment_situation",date.getAppointmentSituation()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(date.getClassName(), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(date.getClassType(), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(isNotString(date.getEarlyReading()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(isNotString(date.getRequiredCourses()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(isNotString(date.getEveningSelfStudy()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(isNotString(date.getAmountTo()), cellcoentFont, pdfCell, pdfPTablegz, 20);
                PDFUtil.addPdfPCell(isNotString(date.getUserName()), cellcoentFont, pdfCell, pdfPTablegz, 20);
            }
            document.add(pdfPTablegz);

            //3.表格 班主任任职
            PdfPTable pdfPTablebzr = PDFUtil.getPdfPTable(10, 100, 1500);
            Chunk qtchunbzr = PDFUtil.getChunk("班主任任职", font);
            Paragraph qtParagraphbzr = PDFUtil.getParagraph(qtchunbzr, Element.ALIGN_LEFT, 0, null);
            qtParagraphbzr.setSpacingAfter(5f);
            qtParagraphbzr.setLeading(15f); //行间距
            qtParagraphbzr.setSpacingBefore(10f); //设置段落上空白
            document.add(qtParagraphbzr);

            List<SchoolAclassTeacherAssessmentVo> schoolAclassTeacherAssessments = comprehensive.getSchoolAclassTeacherAssessments();
            PDFUtil.addPdfPTitleCell("学年", cellFont, pdfCell, pdfPTablebzr, 20);
            PDFUtil.addPdfPTitleCell("学期", cellFont, pdfCell, pdfPTablebzr, 20);
            PDFUtil.addPdfPTitleCell("届别", cellFont, pdfCell, pdfPTablebzr, 20);
            PDFUtil.addPdfPTitleCell("年级", cellFont, pdfCell, pdfPTablebzr, 20);
            PDFUtil.addPdfPTitleCell("班级", cellFont, pdfCell, pdfPTablebzr, 20);
            PDFUtil.addPdfPTitleCell("班级类型", cellFont, pdfCell, pdfPTablebzr, 20);
            PDFUtil.addPdfPTitleCell("教师姓名", cellFont, pdfCell, pdfPTablebzr, 20);
            PDFUtil.addPdfPTitleCell("学科", cellFont, pdfCell, pdfPTablebzr, 20);
            PDFUtil.addPdfPTitleCell("德育考核成绩", cellFont, pdfCell, pdfPTablebzr, 20);
            PDFUtil.addPdfPTitleCell("智育考核成绩", cellFont, pdfCell, pdfPTablebzr, 20);

            for (SchoolAclassTeacherAssessmentVo date: schoolAclassTeacherAssessments){
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("yearda",date.getSchoolYear()), cellcoentFont, pdfCell, pdfPTablebzr, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("semester_jsdzda",date.getSemester()), cellcoentFont, pdfCell, pdfPTablebzr, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("rankda",date.getYear()), cellcoentFont, pdfCell, pdfPTablebzr, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("grade_da",date.getGrade()), cellcoentFont, pdfCell, pdfPTablebzr, 20);
                PDFUtil.addPdfPCell(date.getClassName(), cellcoentFont, pdfCell, pdfPTablebzr, 20);
                PDFUtil.addPdfPCell(date.getClassType(), cellcoentFont, pdfCell, pdfPTablebzr, 20);
                PDFUtil.addPdfPCell(date.getTeacherName(), cellcoentFont, pdfCell, pdfPTablebzr, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("sub_dzdn",date.getSub()), cellcoentFont, pdfCell, pdfPTablebzr, 20);
                PDFUtil.addPdfPCell(isNotString(date.getMoralEduCheckAchievement()), cellcoentFont, pdfCell, pdfPTablebzr, 20);
                PDFUtil.addPdfPCell(isNotString(date.getMoralEduCheckAchievement()), cellcoentFont, pdfCell, pdfPTablebzr, 20);
            }
            document.add(pdfPTablebzr);
            //4.表格 专业成长
            PdfPTable pdfPTablezy = PDFUtil.getPdfPTable(9, 100, 1500);
            Chunk qtchunzy = PDFUtil.getChunk("专业成长", font);
            Paragraph qtParagraphzy = PDFUtil.getParagraph(qtchunzy, Element.ALIGN_LEFT, 0, null);
            qtParagraphzy.setSpacingAfter(5f);
            qtParagraphzy.setLeading(15f); //行间距
            qtParagraphzy.setSpacingBefore(10f); //设置段落上空白
            document.add(qtParagraphzy);
            List<SpecialityVo> specialityVos = comprehensive.getSpecialityVos();
            PDFUtil.addPdfPTitleCell("成长类型", cellFont, pdfCell, pdfPTablezy, 20);
            PDFUtil.addPdfPTitleCell("学科", cellFont, pdfCell, pdfPTablezy, 20);
            PDFUtil.addPdfPTitleCell("获奖类别", cellFont, pdfCell, pdfPTablezy, 20);
            PDFUtil.addPdfPTitleCell("获奖等级", cellFont, pdfCell, pdfPTablezy, 20);
            PDFUtil.addPdfPTitleCell("获奖级别", cellFont, pdfCell, pdfPTablezy, 20);
            PDFUtil.addPdfPTitleCell("成果名称", cellFont, pdfCell, pdfPTablezy, 20);
            PDFUtil.addPdfPTitleCell("教师姓名", cellFont, pdfCell, pdfPTablezy, 20);
            PDFUtil.addPdfPTitleCell("主办单位", cellFont, pdfCell, pdfPTablezy, 20);
            PDFUtil.addPdfPTitleCell("获奖时间", cellFont, pdfCell, pdfPTablezy, 20);
            if (null != specialityVos){

            for (SpecialityVo date: specialityVos){
                PDFUtil.addPdfPCell(date.getGrowthType(), cellcoentFont, pdfCell, pdfPTablezy, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("sub_dzdn",date.getSub()), cellcoentFont, pdfCell, pdfPTablezy, 20);
                PDFUtil.addPdfPCell( conversionType(date.getGrowthType(),date.getAwardtype()), cellcoentFont, pdfCell, pdfPTablezy, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("award_rank",date.getAwardlevel()), cellcoentFont, pdfCell, pdfPTablezy, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("awards_level",date.getAwardrank()), cellcoentFont, pdfCell, pdfPTablezy, 20);
                PDFUtil.addPdfPCell(date.getResultName(), cellcoentFont, pdfCell, pdfPTablezy, 20);
                PDFUtil.addPdfPCell(date.getUserName(), cellcoentFont, pdfCell, pdfPTablezy, 20);
                PDFUtil.addPdfPCell(date.getOrg(), cellcoentFont, pdfCell, pdfPTablezy, 20);
                PDFUtil.addPdfPCell(dateConversionString(date.getAwardTime()), cellcoentFont, pdfCell, pdfPTablezy, 20);
            }

         }
            document.add(pdfPTablezy);

            //5.表格 年度考核
            PdfPTable pdfPTablend = PDFUtil.getPdfPTable(5, 100, 1500);
            Chunk qtchunnd = PDFUtil.getChunk("年度考核", font);
            Paragraph qtParagraphnd = PDFUtil.getParagraph(qtchunnd, Element.ALIGN_LEFT, 0, null);
            qtParagraphnd.setSpacingAfter(5f);
            qtParagraphnd.setLeading(15f); //行间距
            qtParagraphnd.setSpacingBefore(10f); //设置段落上空白
            document.add(qtParagraphnd);

            List<SchoolAnnualAssessment> schoolAnnualAssessment = comprehensive.getSchoolAnnualAssessment();
            PDFUtil.addPdfPTitleCell("年度", cellFont, pdfCell, pdfPTablend, 20);
            PDFUtil.addPdfPTitleCell("姓名", cellFont, pdfCell, pdfPTablend, 20);
            PDFUtil.addPdfPTitleCell("身份证", cellFont, pdfCell, pdfPTablend, 20);
            PDFUtil.addPdfPTitleCell("考核结果", cellFont, pdfCell, pdfPTablend, 20);
            PDFUtil.addPdfPTitleCell("备注", cellFont, pdfCell, pdfPTablend, 20);

            for (SchoolAnnualAssessment date: schoolAnnualAssessment){
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("rankda",date.getYear().toString()), cellcoentFont, pdfCell, pdfPTablend, 20);
                PDFUtil.addPdfPCell(date.getName(), cellcoentFont, pdfCell, pdfPTablend, 20);
                PDFUtil.addPdfPCell(date.getIdCard(), cellcoentFont, pdfCell, pdfPTablend, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("check_result",date.getCheckResult()), cellcoentFont, pdfCell, pdfPTablend, 20);
                PDFUtil.addPdfPCell(date.getRemark(), cellcoentFont, pdfCell, pdfPTablend, 20);
            }
            document.add(pdfPTablend);
            //6.表格 教学成绩
            PdfPTable pdfPTablejx = PDFUtil.getPdfPTable(13, 100, 1500);
            Chunk qtchunjx = PDFUtil.getChunk("教学成绩", font);
            Paragraph qtParagraphndjx = PDFUtil.getParagraph(qtchunjx, Element.ALIGN_LEFT, 0, null);
            qtParagraphndjx.setSpacingAfter(5f);
            qtParagraphndjx.setLeading(15f); //行间距
            qtParagraphndjx.setSpacingBefore(10f); //设置段落上空白
            document.add(qtParagraphndjx);

            List<SchoolXteachingAchievementsVo> schoolXteachingAchievements = comprehensive.getSchoolXteachingAchievements();
            PDFUtil.addPdfPTitleCell("学年", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("学期", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("年级", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("届别", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("姓名", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("身份证号", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("考试时间", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("考试类型", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("学科", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("班级", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("班级类型", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("考核分", cellFont, pdfCell, pdfPTablejx, 20);
            PDFUtil.addPdfPTitleCell("备注", cellFont, pdfCell, pdfPTablejx, 20);

            for (SchoolXteachingAchievementsVo date: schoolXteachingAchievements){
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("yearda",date.getSchoolYear()), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("semester_jsdzda",date.getSemester()), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("grade_da",date.getGrade()), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(date.getGrade(), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(date.getUserName(), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(date.getIdCard(), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(dateConversionString(date.getExamTime()), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("exam_typeda",date.getExamType()), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("sub_dzdn",date.getSub()), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(date.getClassName(), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell( date.getClassType(), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(isNotString(date.getAssessmentScore()), cellcoentFont, pdfCell, pdfPTablejx, 20);
                PDFUtil.addPdfPCell(date.getRemark(), cellcoentFont, pdfCell, pdfPTablejx, 20);
            }
            document.add(pdfPTablejx);
            //7.表格 高考成绩
            PdfPTable pdfPTablegk = PDFUtil.getPdfPTable(10, 100, 1500);
            Chunk qtchungk = PDFUtil.getChunk("高考成绩", font);
            Paragraph qtParagraphndgk = PDFUtil.getParagraph(qtchungk, Element.ALIGN_LEFT, 0, null);
            qtParagraphndgk.setSpacingAfter(5f);
            qtParagraphndgk.setLeading(15f); //行间距
            qtParagraphndgk.setSpacingBefore(10f); //设置段落上空白
            document.add(qtParagraphndgk);

            List<SchoolGkAchievementVo> schoolGkAchievement = comprehensive.getSchoolGkAchievement();
            PDFUtil.addPdfPTitleCell("届别", cellFont, pdfCell, pdfPTablegk, 20);
            PDFUtil.addPdfPTitleCell("学科", cellFont, pdfCell, pdfPTablegk, 20);
            PDFUtil.addPdfPTitleCell("教师姓名", cellFont, pdfCell, pdfPTablegk, 20);
            PDFUtil.addPdfPTitleCell("授课班级", cellFont, pdfCell, pdfPTablegk, 20);
            PDFUtil.addPdfPTitleCell("班级类型", cellFont, pdfCell, pdfPTablegk, 20);
            PDFUtil.addPdfPTitleCell("高考评优", cellFont, pdfCell, pdfPTablegk, 20);
            PDFUtil.addPdfPTitleCell("尖子生培养", cellFont, pdfCell, pdfPTablegk, 20);
            PDFUtil.addPdfPTitleCell("增量情况", cellFont, pdfCell, pdfPTablegk, 20);
            PDFUtil.addPdfPTitleCell("有效数情况", cellFont, pdfCell, pdfPTablegk, 20);
            PDFUtil.addPdfPTitleCell("其他情况", cellFont, pdfCell, pdfPTablegk, 20);

            for (SchoolGkAchievementVo date: schoolGkAchievement){
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("rankda",date.getYear()), cellcoentFont, pdfCell, pdfPTablegk, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("sub_dzdn",date.getSub()), cellcoentFont, pdfCell, pdfPTablegk, 20);
                PDFUtil.addPdfPCell(date.getTeacherName(), cellcoentFont, pdfCell, pdfPTablegk, 20);
                PDFUtil.addPdfPCell(date.getTeachingClassName(), cellcoentFont, pdfCell, pdfPTablegk, 20);
                PDFUtil.addPdfPCell(date.getClassType(), cellcoentFont, pdfCell, pdfPTablegk, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("gk_appraising",date.getGkAppraising()), cellcoentFont, pdfCell, pdfPTablegk, 20);
                PDFUtil.addPdfPCell(date.getTopStudentsCulture(), cellcoentFont, pdfCell, pdfPTablegk, 20);
                PDFUtil.addPdfPCell(date.getIncrementSituation(), cellcoentFont, pdfCell, pdfPTablegk, 20);
                PDFUtil.addPdfPCell(date.getEffectiveNumSituation(), cellcoentFont, pdfCell, pdfPTablegk, 20);
                PDFUtil.addPdfPCell(date.getOther(), cellcoentFont, pdfCell, pdfPTablegk, 20);
            }
            document.add(pdfPTablegk);



            //8.表格 辅导老师获奖
            PdfPTable pdfPTablfdteacher = PDFUtil.getPdfPTable(10, 100, 1500);
            Chunk qtchunfdteacher = PDFUtil.getChunk("辅导老师获奖", font);
            Paragraph qtParagrfdteacher= PDFUtil.getParagraph(qtchunfdteacher, Element.ALIGN_LEFT, 0, null);
            qtParagrfdteacher.setSpacingAfter(5f);
            qtParagrfdteacher.setLeading(15f); //行间距
            qtParagrfdteacher.setSpacingBefore(10f); //设置段落上空白
            document.add(qtParagrfdteacher);

            List<FudaoTeacherVo> fudaoTeacher = comprehensive.getFudaoTeacher();
            PDFUtil.addPdfPTitleCell("成长类型", cellFont, pdfCell, pdfPTablfdteacher, 20);
            PDFUtil.addPdfPTitleCell("学科", cellFont, pdfCell, pdfPTablfdteacher, 20);
            PDFUtil.addPdfPTitleCell("获奖类别", cellFont, pdfCell, pdfPTablfdteacher, 20);
            PDFUtil.addPdfPTitleCell("获奖级别", cellFont, pdfCell, pdfPTablfdteacher, 20);
            PDFUtil.addPdfPTitleCell("班级类比赛名称", cellFont, pdfCell, pdfPTablfdteacher, 20);
            PDFUtil.addPdfPTitleCell("获奖人", cellFont, pdfCell, pdfPTablfdteacher, 20);
            PDFUtil.addPdfPTitleCell("指导教师", cellFont, pdfCell, pdfPTablfdteacher, 20);
            PDFUtil.addPdfPTitleCell("辅导职责", cellFont, pdfCell, pdfPTablfdteacher, 20);
            PDFUtil.addPdfPTitleCell("主办单位", cellFont, pdfCell, pdfPTablfdteacher, 20);
            PDFUtil.addPdfPTitleCell("获奖时间", cellFont, pdfCell, pdfPTablfdteacher, 20);

            for (FudaoTeacherVo date: fudaoTeacher){
                PDFUtil.addPdfPCell("辅导老师获奖", cellcoentFont, pdfCell, pdfPTablfdteacher, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("sub_dzdn",date.getSub()), cellcoentFont, pdfCell, pdfPTablfdteacher, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("award_type_fdjs",date.getAwardtype()), cellcoentFont, pdfCell, pdfPTablfdteacher, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("awards_level",date.getAwardrank()), cellcoentFont, pdfCell, pdfPTablfdteacher, 20);
                PDFUtil.addPdfPCell(date.getCompetitionname(), cellcoentFont, pdfCell, pdfPTablfdteacher, 20);
                PDFUtil.addPdfPCell(date.getUsername(), cellcoentFont, pdfCell, pdfPTablfdteacher, 20);
                PDFUtil.addPdfPCell(date.getGuidanceteacher(), cellcoentFont, pdfCell, pdfPTablfdteacher, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("coachingr",date.getCoachingr()), cellcoentFont, pdfCell, pdfPTablfdteacher, 20);
                PDFUtil.addPdfPCell(date.getOrg(), cellcoentFont, pdfCell, pdfPTablfdteacher, 20);
                PDFUtil.addPdfPCell(dateConversionString(date.getAwardtime()), cellcoentFont, pdfCell, pdfPTablfdteacher, 20);
            }
            document.add(pdfPTablfdteacher);

            //8.表格 辅导学生获奖
            PdfPTable pdfPTablfdStudent = PDFUtil.getPdfPTable(10, 100, 1500);
            Chunk qtchunfdStudent = PDFUtil.getChunk("辅导学生获奖", font);
            Paragraph qtParagrfdStudent= PDFUtil.getParagraph(qtchunfdStudent, Element.ALIGN_LEFT, 0, null);
            qtParagrfdStudent.setSpacingAfter(5f);
            qtParagrfdStudent.setLeading(15f); //行间距
            qtParagrfdStudent.setSpacingBefore(10f); //设置段落上空白
            document.add(qtParagrfdStudent);

            List<FudaoStudentVo> fudaoStudent = comprehensive.getFudaoStudent();
            PDFUtil.addPdfPTitleCell("成长类型", cellFont, pdfCell, pdfPTablfdStudent, 20);
            PDFUtil.addPdfPTitleCell("学科", cellFont, pdfCell, pdfPTablfdStudent, 20);
            PDFUtil.addPdfPTitleCell("获奖类别", cellFont, pdfCell, pdfPTablfdStudent, 20);
            PDFUtil.addPdfPTitleCell("获奖级别", cellFont, pdfCell, pdfPTablfdStudent, 20);
            PDFUtil.addPdfPTitleCell("班级类比赛名称", cellFont, pdfCell, pdfPTablfdStudent, 20);
            PDFUtil.addPdfPTitleCell("获奖人", cellFont, pdfCell, pdfPTablfdStudent, 20);
            PDFUtil.addPdfPTitleCell("指导教师", cellFont, pdfCell, pdfPTablfdStudent, 20);
            PDFUtil.addPdfPTitleCell("主办单位", cellFont, pdfCell, pdfPTablfdStudent, 20);
            PDFUtil.addPdfPTitleCell("获奖时间", cellFont, pdfCell, pdfPTablfdStudent, 20);

            for (FudaoStudentVo date: fudaoStudent){
                PDFUtil.addPdfPCell("辅导学生获奖", cellcoentFont, pdfCell, pdfPTablfdStudent, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("sub_dzdn",date.getSub()), cellcoentFont, pdfCell, pdfPTablfdStudent, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("award_type_fdjs",date.getAwardtype()), cellcoentFont, pdfCell, pdfPTablfdStudent, 20);
                PDFUtil.addPdfPCell(sysDictDataService.selectDictLabel("awards_level",date.getAwardrank()), cellcoentFont, pdfCell, pdfPTablfdStudent, 20);
                PDFUtil.addPdfPCell(date.getResultname(), cellcoentFont, pdfCell, pdfPTablfdStudent, 20);
                PDFUtil.addPdfPCell(date.getUsername(), cellcoentFont, pdfCell, pdfPTablfdStudent, 20);
                PDFUtil.addPdfPCell(date.getGuidanceteacher(), cellcoentFont, pdfCell, pdfPTablfdStudent, 20);
                PDFUtil.addPdfPCell(date.getOrg(), cellcoentFont, pdfCell, pdfPTablfdStudent, 20);
                PDFUtil.addPdfPCell(dateConversionString(date.getAwardtime()), cellcoentFont, pdfCell, pdfPTablfdStudent, 20);
            }
            document.add(pdfPTablfdStudent);
            //导出
            PDFUtil.exportPDF(document, response, outStream);
        }catch (Exception  e){
            e.printStackTrace();
        }

    }

    private String isNotString(Object str){
        String s = String.valueOf(str);
        if (s.equals("null")){
            return "";
        }else {
            return s;
        }
    }

    private String dateConversionString(Date date){
        if (null == date){
            return "";
        }
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy年MM月dd日");
        String format = sdf1.format(date);
        return format;
    }

    private String conversionType(String type,String value){
        switch (type){
            case "综合荣誉": return   value;
            case "教学获奖": return sysDictDataService.selectDictLabel("award_categoriesjs",value);
            case "成长类型": return sysDictDataService.selectDictLabel("award_categoriesjk",value);
            case "论文论著": return sysDictDataService.selectDictLabel("award_categories",value);
            case "课题研究": return sysDictDataService.selectDictLabel("project_research",value);
        }
        return "";
    }


}
