package yangtz.cs.liu.campus.controller.schoolNewTeacherDzdn;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;

import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolGkAchievement;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolGkAchievementVo;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolGkAchievementService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteachingAchievementsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXcomprehensiveHonorsVo;

/**
 * 高考成绩Controller
 *
 * @author ruoyi
 * @date 2023-12-13
 */
@RestController
@RequestMapping("/achievement")
public class SchoolGkAchievementController extends BaseController
{
    @Autowired
    private ISchoolGkAchievementService schoolGkAchievementService;
    @Autowired
    private ISchoolXteachingAchievementsService schoolXteachingAchievementsService;
    @Autowired
    private ISysDeptService sysDeptService;
    @Autowired
    private SchoolTeacherBasichlnformationService basichlnformationService;

    /**
     * 查询高考成绩列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolGkAchievementVo schoolGkAchievementVo)
    {

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            startPage();
            List<SchoolGkAchievementVo> list = schoolGkAchievementService.selectSchoolGkAchievementVoList(schoolGkAchievementVo);
            return getDataTable(list);
        }
        //全部权限
        List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("gkcj_admin")).collect(Collectors.toList());
        if (roleList.size() > 0){
            startPage();
            List<SchoolGkAchievementVo> list = schoolGkAchievementService.selectSchoolGkAchievementVoList(schoolGkAchievementVo);
            return getDataTable(list);
        }
        //部分权限
        List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
        //查询是否包含学科组长角色
        List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
        if (roleList1.size() > 0){
            //教师电子档案中级管理员只能查看本部门及部门以下的数据
            //根据用户部门id查询用户部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            //查询本部门下所有教师的id
            List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
            if (deptUserIds.size() > 0){
                schoolGkAchievementVo.setUserIds(deptUserIds);
            }
            if (roleList2.size() > 0){
                //根据当前登陆人手机号查询任教学科
                String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                schoolGkAchievementVo.setSub1(sub);
            }
            startPage();
            List<SchoolGkAchievementVo> list = schoolGkAchievementService.selectSchoolGkAchievementVoList(schoolGkAchievementVo);
            return getDataTable(list);
        }
        if (roleList2.size() > 0){
            //根据当前登陆人手机号查询任教学科
            String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
            schoolGkAchievementVo.setSub1(sub);
            startPage();
            List<SchoolGkAchievementVo> list = schoolGkAchievementService.selectSchoolGkAchievementVoList(schoolGkAchievementVo);
            return getDataTable(list);
        }
        return getDataTable(new ArrayList<>());
    }


    /**
     * 老师个人页面列表
     */

    @GetMapping("/teacher/list")
    public TableDataInfo teacherList(SchoolGkAchievementVo schoolGkAchievementVo){
        startPage();
        List<SchoolGkAchievement> list = schoolGkAchievementService.selectSchoolGkAchievementList(schoolGkAchievementVo);
        return getDataTable(list);
    }


    /**
     * 获取高考成绩详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolGkAchievementService.selectSchoolGkAchievementById(id));
    }

    /**
     * 新增高考成绩
     */
    @Log(title = "高考成绩", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolGkAchievement schoolGkAchievement)
    {
        return toAjax(schoolGkAchievementService.insertSchoolGkAchievement(schoolGkAchievement));
    }

    /**
     * 修改高考成绩
     */
    @Log(title = "高考成绩", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolGkAchievement schoolGkAchievement)
    {
        return toAjax(schoolGkAchievementService.updateById(schoolGkAchievement));
    }

    /**
     * 删除高考成绩
     */
    @Log(title = "高考成绩", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolGkAchievementService.deleteSchoolGkAchievementByIds(ids));
    }


    /**
     * 导出高考成绩列表
     */
    @Log(title = "高考成绩", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolGkAchievementVo schoolGkAchievementVo)
    {

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            List<SchoolGkAchievement> list = schoolGkAchievementService.selectSchoolGkAchievementList(schoolGkAchievementVo);
            ExcelUtil<SchoolGkAchievement> util = new ExcelUtil<SchoolGkAchievement>(SchoolGkAchievement.class);
            util.exportExcel(response, list, "高考成绩数据");
        }else {
            //全部权限
            List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("gkcj_admin")).collect(Collectors.toList());
            if (roleList.size() > 0){
                List<SchoolGkAchievement> list = schoolGkAchievementService.selectSchoolGkAchievementList(schoolGkAchievementVo);
                ExcelUtil<SchoolGkAchievement> util = new ExcelUtil<SchoolGkAchievement>(SchoolGkAchievement.class);
                util.exportExcel(response, list, "高考成绩数据");
            }else {
                //部分权限
                List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
                //查询是否包含学科组长角色
                List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
                if (roleList1.size() > 0){
                    //教师电子档案中级管理员只能查看本部门及部门以下的数据
                    //根据用户部门id查询用户部门信息
                    SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
                    //查询本部门下所有教师的id
                    List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
                    if (deptUserIds.size() > 0){
                        schoolGkAchievementVo.setUserIds(deptUserIds);
                    }
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolGkAchievementVo.setSub1(sub);
                    }
                    List<SchoolGkAchievement> list = schoolGkAchievementService.selectSchoolGkAchievementList(schoolGkAchievementVo);
                    ExcelUtil<SchoolGkAchievement> util = new ExcelUtil<SchoolGkAchievement>(SchoolGkAchievement.class);
                    util.exportExcel(response, list, "高考成绩数据");
                } else {
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        schoolGkAchievementVo.setSub1(sub);
                        List<SchoolGkAchievement> list = schoolGkAchievementService.selectSchoolGkAchievementList(schoolGkAchievementVo);
                        ExcelUtil<SchoolGkAchievement> util = new ExcelUtil<SchoolGkAchievement>(SchoolGkAchievement.class);
                        util.exportExcel(response, list, "高考成绩数据");
                    }else {
                        ExcelUtil<SchoolGkAchievement> util = new ExcelUtil<SchoolGkAchievement>(SchoolGkAchievement.class);
                        util.exportExcel(response, new ArrayList<>(), "高考成绩数据");
                    }
                }
            }
        }
    }
}
