package yangtz.cs.liu.campus.controller.schoolLab;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherLabApply;
import yangtz.cs.liu.campus.service.accessory.IAccessoryService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolTeacherLabApplyService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherLabApplyVo;

/**
 * 教师实验室申请Controller
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@RestController
@RequestMapping("/schoolTeacherLabApply")
public class SchoolTeacherLabApplyController extends BaseController
{
    @Autowired
    private ISchoolTeacherLabApplyService schoolTeacherLabApplyService;
    @Autowired
    private IAccessoryService accessoryService;

    /**
     * 查询教师实验室申请列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
    {
        //获取登录用户
        SysUser user = SecurityUtils.getLoginUser().getUser();
        if (user.isAdmin()){
            startPage();
            List<SchoolTeacherLabApplyVo> schoolTeacherLabApplyVos = schoolTeacherLabApplyService.selectSchoolTeacherLabApplyList(schoolTeacherLabApplyVo);
            for (SchoolTeacherLabApplyVo teacherLabApplyVo : schoolTeacherLabApplyVos) {
                LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(SchoolAccessory::getBusinessId,teacherLabApplyVo.getId())
                        .eq(SchoolAccessory::getAccessoryType,"教师实验室附件");
                List<SchoolAccessory> schoolAccessories = accessoryService.list(wrapper);
                if (schoolAccessories.size() > 0){
                    teacherLabApplyVo.setSchoolAccessoryList(schoolAccessories);
                }
                String semester = "";
                if (teacherLabApplyVo.getSemester().equals("1")){
                    semester = "上学期";
                }else {
                    semester = "下学期";
                }
                teacherLabApplyVo.setSchoolYearSemester(teacherLabApplyVo.getSchoolYear() + semester);
            }
            return getDataTable(schoolTeacherLabApplyVos);
        }
        //普通教师通道
        schoolTeacherLabApplyVo.setApplyId(user.getUserId());
        startPage();
        List<SchoolTeacherLabApplyVo> schoolTeacherLabApplyVos = schoolTeacherLabApplyService.selectSchoolTeacherLabApplyList(schoolTeacherLabApplyVo);
        for (SchoolTeacherLabApplyVo teacherLabApplyVo : schoolTeacherLabApplyVos) {
            LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolAccessory::getBusinessId,teacherLabApplyVo.getId())
                    .eq(SchoolAccessory::getAccessoryType,"教师实验室附件");
            List<SchoolAccessory> schoolAccessories = accessoryService.list(wrapper);
            if (schoolAccessories.size() > 0){
                teacherLabApplyVo.setSchoolAccessoryList(schoolAccessories);
            }
            String semester = "";
            if (teacherLabApplyVo.getSemester().equals("1")){
                semester = "上学期";
            }else {
                semester = "下学期";
            }
            teacherLabApplyVo.setSchoolYearSemester(teacherLabApplyVo.getSchoolYear() + semester);
        }
        return getDataTable(schoolTeacherLabApplyVos);
    }

    /**
     * 导出教师实验室申请列表
     */
    @Log(title = "教师实验室申请", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
    {
        List<SchoolTeacherLabApplyVo> list = schoolTeacherLabApplyService.selectSchoolTeacherLabApplyList(schoolTeacherLabApplyVo);
        ExcelUtil<SchoolTeacherLabApplyVo> util = new ExcelUtil<SchoolTeacherLabApplyVo>(SchoolTeacherLabApplyVo.class);
        util.exportExcel(response, list, "教师实验室申请数据");
    }

    /**
     * 获取教师实验室申请详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        SchoolTeacherLabApplyVo schoolTeacherLabApplyVo = schoolTeacherLabApplyService.selectSchoolTeacherLabApplyById(id);
        LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAccessory::getBusinessId,id)
                .eq(SchoolAccessory::getAccessoryType,"教师实验室附件");
        List<SchoolAccessory> schoolAccessories = accessoryService.list(wrapper);
        if (schoolAccessories.size() > 0){
            schoolTeacherLabApplyVo.setSchoolAccessoryList(schoolAccessories);
        }
        String semester = "";
        if (schoolTeacherLabApplyVo.getSemester().equals("1")){
            semester = "上学期";
        }else {
            semester = "下学期";
        }
        schoolTeacherLabApplyVo.setSchoolYearSemester(schoolTeacherLabApplyVo.getSchoolYear() + semester);
        return AjaxResult.success(schoolTeacherLabApplyVo);
    }

    /**
     * 新增教师实验室申请
     */
    @Log(title = "教师实验室申请", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
    {
        return toAjax(schoolTeacherLabApplyService.insertSchoolTeacherLabApplyVo(schoolTeacherLabApplyVo));
    }

    /**
     * 修改教师实验室申请
     */
    @Log(title = "教师实验室申请", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
    {
        return toAjax(schoolTeacherLabApplyService.updateSchoolTeacherLabApplyVo(schoolTeacherLabApplyVo));
    }

    /**
     * 删除教师实验室申请
     */
    @Log(title = "教师实验室申请", businessType = BusinessType.DELETE)
    @PostMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolTeacherLabApplyService.deleteSchoolTeacherLabApplyByIds(ids));
    }

    /**
     * 获取实验室使用状态
     * @return
     */
    @GetMapping("/getTeacherLab")
    public AjaxResult getTeacherLab(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo){
        return AjaxResult.success(schoolTeacherLabApplyService.getTeacherLab(schoolTeacherLabApplyVo));
    }

    /**
     * 获取班级
     */
    @GetMapping("/getTeacherClass")
    public AjaxResult getTeacherClass(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo){
       return AjaxResult.success(schoolTeacherLabApplyService.getTeacherClass(schoolTeacherLabApplyVo,null));
    }

    /**
     * 上传附件
     */
    @PutMapping("/attachment")
    public AjaxResult attachment(@RequestBody SchoolTeacherLabApplyVo schoolTeacherLabApplyVo){
        return toAjax(schoolTeacherLabApplyService.updateTeacherLab(schoolTeacherLabApplyVo));
    }

    /**
     * 实验室管理-教师申请列表
     */
    @GetMapping("/getTeacherLabApplyList")
    public TableDataInfo getTeacherLabApplyList(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo){
        startPage();
        List<SchoolTeacherLabApplyVo> list = schoolTeacherLabApplyService.getTeacherLabApplyList(schoolTeacherLabApplyVo);
        return getDataTable(list);
    }

    /**
     * 实验室管理-教师申请审批确认
     */
    @PutMapping("/updateState")
    public AjaxResult updateState(@RequestBody SchoolTeacherLabApply schoolTeacherLabApply){
        return toAjax(schoolTeacherLabApplyService.updateState(schoolTeacherLabApply));
    }

    /**
     * 实验室管理-查看实验室使用记录明细
     */
    @GetMapping("/getLabUserDetial")
    public TableDataInfo getLabUserDetial(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo){
        //查询已确认的实验室使用记录
        schoolTeacherLabApplyVo.setApplyState("1");
        startPage();
        return getDataTable(schoolTeacherLabApplyService.selectSchoolTeacherLabApplyList(schoolTeacherLabApplyVo));
    }

}
