package yangtz.cs.liu.campus.controller.schoolInstrument;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.service.schoolInstrument.ISchoolInstrumentService;
import yangtz.cs.liu.campus.service.schoolInstrument.ISchoolTeacherBorrowService;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolInstrumentVo;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolTeacherBorrowVo;

import java.util.List;

/**
 * 教师借用Controller
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/schoolTeacherBorrow")
public class SchoolTeacherBorrowController extends BaseController {

    @Autowired
    private ISchoolTeacherBorrowService schoolTeacherBorrowService;
    @Autowired
    private ISchoolInstrumentService schoolInstrumentService;

    /**
     * 查询教师借用列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherBorrowVo schoolTeacherBorrowVo)
    {
        startPage();
        List<SchoolTeacherBorrowVo> list = schoolTeacherBorrowService.selectSchoolTeacherBorrowList(schoolTeacherBorrowVo);
        return getDataTable(list);
    }

    /**
     * 获取教师借用详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolTeacherBorrowService.selectSchoolTeacherBorrowById(id));
    }

    /**
     * 新增教师借用
     */
    @Log(title = "教师借用", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolTeacherBorrowVo schoolTeacherBorrowVo)
    {
        return toAjax(schoolTeacherBorrowService.insertSchoolTeacherBorrow(schoolTeacherBorrowVo));
    }

    /**
     * 办理教师借用
     */
    @Log(title = "教师借用", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolTeacherBorrowVo schoolTeacherBorrowVo)
    {
        return toAjax(schoolTeacherBorrowService.updateSchoolTeacherBorrow(schoolTeacherBorrowVo));
    }

    /**
     * 删除教师借用
     */
    @Log(title = "教师借用", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolTeacherBorrowService.deleteSchoolTeacherBorrowByIds(ids));
    }

    /**
     * 借用明细列表
     */
    @GetMapping("/selectInstrumentList")
    public TableDataInfo selectInstrumentList(SchoolInstrumentVo schoolInstrumentVo)
    {
        return getDataTable(schoolInstrumentService.selectInstrumentList(schoolInstrumentVo));
    }

    /**
     * 仓库借用管理列表
     */
    @GetMapping("/selectBorrowInstrumentList")
    public TableDataInfo selectBorrowInstrumentList(SchoolTeacherBorrowVo schoolTeacherBorrowVo)
    {
        startPage();
        List<SchoolTeacherBorrowVo> list = schoolTeacherBorrowService.selectBorrowInstrumentList(schoolTeacherBorrowVo);
        return getDataTable(list);
    }

    /**
     * 归还教师借出仪器
     */
    @PostMapping("/returnInstrument")
    public AjaxResult returnInstrument(@RequestBody SchoolTeacherBorrowVo schoolTeacherBorrowVo){
        return toAjax(schoolTeacherBorrowService.returnInstrument(schoolTeacherBorrowVo));
    }
}
