package yangtz.cs.liu.campus.controller.schoolInstrument;


import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrumentDetail;
import yangtz.cs.liu.campus.service.schoolInstrument.ISchoolInstrumentDetailService;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolInstrumentDetailVo;

import java.util.List;

/**
 * 仪器出入库明细Controller
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/schoolInstrumentDetail")
public class SchoolInstrumentDetailController extends BaseController {

    @Autowired
    private ISchoolInstrumentDetailService schoolInstrumentDetailService;

    /**
     * 查询仪器出入库明细列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolInstrumentDetailVo schoolInstrumentDetailVo)
    {
        startPage();
        List<SchoolInstrumentDetail> list = schoolInstrumentDetailService.selectSchoolInstrumentDetailList(schoolInstrumentDetailVo);
        return getDataTable(list);
    }

    /**
     * 获取仪器出入库明细详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolInstrumentDetailService.selectSchoolInstrumentDetailById(id));
    }

    /**
     * 新增仪器出入库明细
     */
    @Log(title = "仪器出入库明细", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolInstrumentDetail schoolInstrumentDetail)
    {
        return toAjax(schoolInstrumentDetailService.insertSchoolInstrumentDetail(schoolInstrumentDetail));
    }

    /**
     * 修改仪器出入库明细
     */
    @Log(title = "仪器出入库明细", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolInstrumentDetail schoolInstrumentDetail)
    {
        return toAjax(schoolInstrumentDetailService.updateSchoolInstrumentDetail(schoolInstrumentDetail));
    }

    /**
     * 删除仪器出入库明细
     */
    @Log(title = "仪器出入库明细", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolInstrumentDetailService.deleteSchoolInstrumentDetailByIds(ids));
    }
}
