package yangtz.cs.liu.campus.controller.schoolInfo;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.constant.InfoAcquisitionConstant;
import yangtz.cs.liu.campus.domain.schoolInfo.SchoolInfoAcquisition;
import yangtz.cs.liu.campus.domain.schoolInfo.SchoolInfoDetail;
import yangtz.cs.liu.campus.service.schoolInfo.ISchoolInfoAcquisitionService;
import yangtz.cs.liu.campus.service.schoolInfo.ISchoolInfoDetailService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author xuten
 */
@RestController
@RequestMapping("/schoolInfo")
public class SchoolInfoAcquisitionController extends BaseController {
    @Autowired
    private ISchoolInfoAcquisitionService acquisitionService;

    @Autowired
    private ISchoolInfoDetailService detailService;

    /**
     * 教务-信息采集-查询信息采集列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolInfoAcquisition schoolInfoAcquisition)
    {
        startPage();
        List<SchoolInfoAcquisition> list = acquisitionService.queryList(schoolInfoAcquisition);
        return getDataTable(list);
    }

    /**
     * 教务-信息采集-新增信息采集
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolInfoAcquisition schoolInfoAcquisition)
    {
        //设置状态为未发布
        schoolInfoAcquisition.setInfoType(InfoAcquisitionConstant.NOPUB);
        schoolInfoAcquisition.insert();
        return toAjax(acquisitionService.save(schoolInfoAcquisition));
    }

    /**
     * 教务-信息采集-获取信息采集详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(acquisitionService.getById(id));
    }

    /**
     * 教务-信息采集-修改信息采集
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolInfoAcquisition schoolInfoAcquisition)
    {
        if(StringUtils.isNull(schoolInfoAcquisition.getId())){
            throw new ServiceException("id不能为空");
        }
        schoolInfoAcquisition.update();
        return toAjax(acquisitionService.updateById(schoolInfoAcquisition));
    }

    /**
     * 删除信息采集
     */
    @DeleteMapping("/delete/{id}")
    public AjaxResult remove(@PathVariable Long id)
    {
        //删子表
        LambdaQueryWrapper<SchoolInfoDetail> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolInfoDetail::getInfoId,id);
        detailService.remove(lqw);
        return toAjax(acquisitionService.removeById(id));
    }

    /**
     * 教务-信息采集-发布
     */
    @PutMapping("/pub/{id}")
    public AjaxResult pub(@PathVariable("id") Long id) {
        LambdaQueryWrapper<SchoolInfoDetail> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolInfoDetail::getInfoId,id);
        List<SchoolInfoDetail> list = detailService.list(lqw);
        if(StringUtils.isNull(list) || list.size() == 0){
            throw new ServiceException("该信息采集下暂无学生数据，不允许发布，请检查");
        }
        LambdaUpdateWrapper<SchoolInfoAcquisition> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolInfoAcquisition::getId,id).set(SchoolInfoAcquisition::getInfoType,InfoAcquisitionConstant.PUB);
        return toAjax(acquisitionService.update(luw));
    }

    /**
     * 教务-信息采集-撤回
     */
    @PutMapping("/withdraw/{id}")
    public AjaxResult withdraw(@PathVariable("id") Long id) {
        return toAjax(detailService.withdraw(id));
    }

    @PutMapping("/end/{id}")
    public AjaxResult end(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolInfoAcquisition> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolInfoAcquisition::getId,id).set(SchoolInfoAcquisition::getInfoType,InfoAcquisitionConstant.GETEND);
        return toAjax(acquisitionService.update(luw));
    }

    /**
     * 教务-信息采集-数据、数据查看-列表
     * infoId 为主表id
     * */
    @GetMapping("/dataList/{infoId}")
    public TableDataInfo dataList(@PathVariable Long infoId,SchoolInfoDetail schoolInfoDetail)
    {
        schoolInfoDetail.setInfoId(infoId);
        startPage();
        List<SchoolInfoDetail> list = detailService.queryList(schoolInfoDetail);
        return getDataTable(list);
    }

    /**
     * 教务-信息采集-数据、数据查看-新增
     */
    @PostMapping("/detail/add/{infoId}")
    public AjaxResult detailAdd(@RequestBody @Validated SchoolInfoDetail detail, @PathVariable Long infoId)
    {
        detail.setInfoId(infoId);
        return toAjax(detailService.add(detail));
    }

    /**
     * 教务-信息采集-数据、数据查看-获取详细信息
     * id 为子表id
     */
    @GetMapping(value = "/detail/getInfo/{id}")
    public AjaxResult getDetailInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(detailService.getById(id));
    }

    /**
     * 教务-信息采集--数据、数据查看-修改
     */
    @PutMapping("/detail/edit")
    public AjaxResult detailEdit(@RequestBody @Validated SchoolInfoDetail detail)
    {
        if(StringUtils.isNull(detail.getId())){
            throw new ServiceException("id不能为空");
        }
        return toAjax(detailService.edit(detail));
    }

    /**
     * 教务-信息采集--数据、数据查看-删除
     * id为子表id
     */
    @DeleteMapping("/detail/delete/{id}")
    public AjaxResult detailRemove(@PathVariable Long id)
    {
        return toAjax(detailService.removeById(id));
    }

    /**
     * 教务-信息采集--数据、数据查看-导出
     * infoId 主表
     */
    @PostMapping("/export/{infoId}")
    public void export(HttpServletResponse response, SchoolInfoDetail schoolInfoDetail,@PathVariable Long infoId)
    {
        schoolInfoDetail.setInfoId(infoId);
        List<SchoolInfoDetail> list = detailService.queryList(schoolInfoDetail);
        ExcelUtil<SchoolInfoDetail> util = new ExcelUtil<SchoolInfoDetail>(SchoolInfoDetail.class);
        util.exportExcel(response, list, "信息采集详情数据");
    }

    /**
     * 教务-信息采集--数据、数据查看-模板
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<SchoolInfoDetail> util = new ExcelUtil<SchoolInfoDetail>(SchoolInfoDetail.class);
        util.importTemplateExcel(response, "信息采集详情数据");
    }

    /**
     * 教务-信息采集--数据、数据查看-导入
     */
    @PostMapping("/importData/{infoId}")
    public AjaxResult importStudent(MultipartFile file,@PathVariable Long infoId) throws Exception {
        ExcelUtil<SchoolInfoDetail> util = new ExcelUtil<SchoolInfoDetail>(SchoolInfoDetail.class);
        List<SchoolInfoDetail> list = util.importExcel(file.getInputStream());
        //先校验
        detailService.checkImport(list);
        //数据导入
        String message = detailService.importData(list,infoId);
        return AjaxResult.success(message);

    }
}
