package yangtz.cs.liu.campus.controller.schoolDuty;

import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolDuty.SchoolDuty;
import yangtz.cs.liu.campus.domain.schoolDuty.SchoolDutyDetails;
import yangtz.cs.liu.campus.service.schoolDuty.ISchoolDutyDetailsService;
import yangtz.cs.liu.campus.service.schoolDuty.ISchoolDutyService;

import java.util.List;

import static yangtz.cs.liu.campus.constant.DutyType.PUBLISHED;
import static yangtz.cs.liu.campus.constant.DutyType.UNPUBLISHED;

/**
 * 值班管理Controller
 *
 */
@RestController
@RequestMapping("/duty")
public class SchoolDutyController extends BaseController
{
    @Autowired
    private ISchoolDutyService schoolDutyService;

    @Autowired
    private ISchoolDutyDetailsService detailsService;

    /**
     * 查询值班管理列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolDuty schoolDuty)
    {
        startPage();
        List<SchoolDuty> list = schoolDutyService.selectSchoolDutyList(schoolDuty);
        return getDataTable(list);
    }

    /**
     * 导出值班管理列表
     */
    @Log(title = "导出值班管理列表", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response,@RequestBody SchoolDuty schoolDuty)
    {
        List<SchoolDuty> list = schoolDutyService.queryList(schoolDuty);
        ExcelUtil<SchoolDuty> util = new ExcelUtil<SchoolDuty>(SchoolDuty.class);
        util.exportExcel(response, list, "节日管理值班表");
    }

    /**
     * 导入值班管理列表
     */
    @Log(title = "导入值班管理列表", businessType = BusinessType.EXPORT)
    @PostMapping("/imporData")
    public AjaxResult imporData(MultipartFile file)
    {
      /*  ExcelUtil<SchoolBudgetVo> util = new ExcelUtil<SchoolBudgetVo>(SchoolBudgetVo.class);
        List<SchoolBudgetVo> list = util.importExcel(file.getInputStream());
        //先校验
        schoolBudgetService.checkImport(list);
        String message = schoolBudgetService.importSchoolBudgetVoList(list);
        return AjaxResult.success(message);*/
        ExcelUtil<SchoolDuty> util = new ExcelUtil<SchoolDuty>(SchoolDuty.class);
        List<SchoolDuty> schoolDuties = null;
        try {
            schoolDuties = util.importExcel(file.getInputStream());
        } catch (Exception e) {
            throw new ServiceException("导入失败");
        }
        schoolDutyService.importSchoolBudgetVoList(schoolDuties);
        return AjaxResult.success("导入成功");
    }


    /**
     * 导出值班管理列表-寒暑假
     */
/*    @Log(title = "值班管理", businessType = BusinessType.EXPORT)
    @PostMapping("/exportVacation")
    public void exportVacation(HttpServletResponse response, SchoolDuty schoolDuty)
    {
        List<SchoolDuty> list = schoolDutyService.queryList(schoolDuty);
        LambdaUpdateWrapper<SchoolDuty> luw = new LambdaUpdateWrapper<>();
        ExcelUtil<SchoolDuty> util = new ExcelUtil<SchoolDuty>(SchoolDuty.class);
        util.exportExcel(response, list, "寒暑假值班表");
    }*/


    @GetMapping(value = "/queryById/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolDutyService.getById(id));
    }

    /**
     * 新增值班管理
     */
    @Log(title = "值班管理", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolDuty schoolDuty)
    {
//        Boolean flag = schoolDutyService.checkIsExist(schoolDuty);
//        //存在
//        if (flag) {
//            throw new ServiceException("该值班已存在，请勿重复添加");
//        }

        schoolDuty.insert();
        return toAjax(schoolDutyService.save(schoolDuty));
    }

    /**
     * 修改值班管理
     */
    @Log(title = "值班管理", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolDuty schoolDuty)
    {
        if (StringUtils.isNull(schoolDuty.getId())) {
            throw new ServiceException("id为空");
        }
        return toAjax(schoolDutyService.updateSchoolDuty(schoolDuty));
    }

    /**
     * 删除值班管理
     */
    @Log(title = "值班管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable Long ids)
    {
        return toAjax(schoolDutyService.removeById(ids));
    }

    /**发布*/
    @PutMapping("/published/{id}")
    public AjaxResult published(@PathVariable Long id)
    {
        //查看是否有子数据，没有子数据不能发布
        LambdaQueryWrapper<SchoolDutyDetails> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolDutyDetails::getDutyId,id);
        List<SchoolDutyDetails> list = detailsService.list(lqw);
        if(StringUtils.isNull(list) || list.size() == 0){
            throw new ServiceException("该值班暂无值班安排，无法发布");
        }
        LambdaUpdateWrapper<SchoolDuty> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolDuty::getId,id).set(SchoolDuty::getState,PUBLISHED);
        return toAjax(schoolDutyService.update(luw));
    }

    /**撤回*/
    @PutMapping("/withdraw/{id}")
    public AjaxResult withdraw(@PathVariable Long id)
    {
        LambdaUpdateWrapper<SchoolDuty> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolDuty::getId,id).set(SchoolDuty::getState,UNPUBLISHED);
        return toAjax(schoolDutyService.update(luw));
    }
}
