package yangtz.cs.liu.campus.controller.schoolDcwj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjNr;
import yangtz.cs.liu.campus.service.schoolDcwj.ISchoolDcwjNrService;
import yangtz.cs.liu.campus.vo.schoolDcwj.SchoolDcwjNrVo;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static yangtz.cs.liu.campus.constant.DcwjType.PIC;
import static yangtz.cs.liu.campus.constant.DcwjType.TIANKONG;

/**
 * 内容问题Controller
 *
 * @author wengxiulin
 * @date 2023-02-27
 */
@RestController
@RequestMapping("/dcwjNr")
public class SchoolDcwjNrController extends BaseController
{
    @Autowired
    private ISchoolDcwjNrService schoolDcwjNrService;

    /**
     * 级部-班主任模块，问卷调查内容查看
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolDcwjNr schoolDcwjNr)
    {

        //startPage();
        if(StringUtils.isNull(schoolDcwjNr.getDcwjId())){
            throw new ServiceException("id为空");
        }
        //查出对应问卷的内容
        LambdaQueryWrapper<SchoolDcwjNr> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolDcwjNr::getDcwjId,schoolDcwjNr.getDcwjId())
                .like(isNotNull(schoolDcwjNr.getNrBt()),SchoolDcwjNr::getNrBt,schoolDcwjNr.getNrBt())
                .orderByAsc(SchoolDcwjNr::getNrPx)
                .orderByDesc(SchoolDcwjNr::getCreateTime)
        ;
        List<SchoolDcwjNr> dcwjNrList = schoolDcwjNrService.list(lqw);
//        List<SchoolDcwjNr> dcwjNrList = schoolDcwjNrService.selectSchoolDcwjNrList(schoolDcwjNr);
        List<SchoolDcwjNrVo> list = new ArrayList<>();

        for (SchoolDcwjNr dcwjNr:dcwjNrList) {
            SchoolDcwjNrVo schoolDcwjNrVo = new SchoolDcwjNrVo();
            schoolDcwjNrVo.setId(dcwjNr.getId());
            schoolDcwjNrVo.setDcwjId(dcwjNr.getDcwjId());
            schoolDcwjNrVo.setNrBt(dcwjNr.getNrBt());
            schoolDcwjNrVo.setNrLx(dcwjNr.getNrLx());
            schoolDcwjNrVo.setNrPx(dcwjNr.getNrPx());
            schoolDcwjNrVo.setNrSfbt(dcwjNr.getNrSfbt());

            String nr = "";
            if (StringUtils.isNotNull(dcwjNr.getNrA()) && !("".equals(dcwjNr.getNrA()))){
                nr = nr+"选项1:"+dcwjNr.getNrA()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrB())&& !("".equals(dcwjNr.getNrB()))){
                nr = nr+" 选项2:"+dcwjNr.getNrB()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrC())&& !("".equals(dcwjNr.getNrC()))){
                nr = nr+" 选项3:"+dcwjNr.getNrC()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrD())&& !("".equals(dcwjNr.getNrD()))){
                nr = nr+" 选项4:"+dcwjNr.getNrD()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrE())&& !("".equals(dcwjNr.getNrE()))){
                nr = nr+" 选项5:"+dcwjNr.getNrE()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrF())&& !("".equals(dcwjNr.getNrF()))){
                nr = nr+" 选项6:"+dcwjNr.getNrF()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrG())&& !("".equals(dcwjNr.getNrG()))){
                nr = nr+" 选项7:"+dcwjNr.getNrG()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrH())&& !("".equals(dcwjNr.getNrH()))){
                nr = nr+" 选项8:"+dcwjNr.getNrH()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrI())&& !("".equals(dcwjNr.getNrI()))){
                nr = nr+"选项9:"+dcwjNr.getNrI()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrJ())&& !("".equals(dcwjNr.getNrJ()))){
                nr = nr+" 选项10:"+dcwjNr.getNrJ()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrK())&& !("".equals(dcwjNr.getNrK()))){
                nr = nr+" 选项11:"+dcwjNr.getNrK()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrL())&& !("".equals(dcwjNr.getNrL()))){
                nr = nr+" 选项12:"+dcwjNr.getNrL()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrM())&& !("".equals(dcwjNr.getNrM()))){
                nr = nr+" 选项13:"+dcwjNr.getNrM()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrN())&& !("".equals(dcwjNr.getNrN()))){
                nr = nr+" 选项14:"+dcwjNr.getNrN()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrO())&& !("".equals(dcwjNr.getNrO()))){
                nr = nr+" 选项15:"+dcwjNr.getNrO()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrP()) && !("".equals(dcwjNr.getNrP()))){
                nr = nr+"选项16:"+dcwjNr.getNrP()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrQ())&& !("".equals(dcwjNr.getNrQ()))){
                nr = nr+" 选项17:"+dcwjNr.getNrQ()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrR())&& !("".equals(dcwjNr.getNrR()))){
                nr = nr+" 选项18:"+dcwjNr.getNrR()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrS())&& !("".equals(dcwjNr.getNrS()))){
                nr = nr+" 选项19:"+dcwjNr.getNrS()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrT())&& !("".equals(dcwjNr.getNrT()))){
                nr = nr+" 选项20:"+dcwjNr.getNrT()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrU())&& !("".equals(dcwjNr.getNrU()))){
                nr = nr+" 选项21:"+dcwjNr.getNrU()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrV())&& !("".equals(dcwjNr.getNrV()))){
                nr = nr+" 选项22:"+dcwjNr.getNrV()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrW())&& !("".equals(dcwjNr.getNrW()))){
                nr = nr+" 选项23:"+dcwjNr.getNrW()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrX())&& !("".equals(dcwjNr.getNrX()))){
                nr = nr+"选项24:"+dcwjNr.getNrX()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrY())&& !("".equals(dcwjNr.getNrY()))){
                nr = nr+" 选项25:"+dcwjNr.getNrY()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrZ())&& !("".equals(dcwjNr.getNrZ()))){
                nr = nr+" 选项26:"+dcwjNr.getNrZ()+ ";";
            }
            schoolDcwjNrVo.setNr(nr);

            list.add(schoolDcwjNrVo);
        }
        return getTaskTable(list,dcwjNrList.size());
    }

    /**
     * 导出内容问题列表
     */
    @Log(title = "内容问题", businessType = BusinessType.EXPORT)
    @PostMapping("/export/{dcwjId}")
    public void export(HttpServletResponse response, @PathVariable("dcwjId") Long dcwjId)
    {
        LambdaQueryWrapper<SchoolDcwjNr> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolDcwjNr::getDcwjId,dcwjId).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
        List<SchoolDcwjNr> list = schoolDcwjNrService.list(lqw);
        ExcelUtil<SchoolDcwjNr> util = new ExcelUtil<SchoolDcwjNr>(SchoolDcwjNr.class);
        util.exportExcel(response, list, "内容问题数据");
    }

    /**
     * 下载内容问题列表模板
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response){
        ExcelUtil<SchoolDcwjNr> util = new ExcelUtil<SchoolDcwjNr>(SchoolDcwjNr.class);
        util.importTemplateExcel(response, "内容问题数据");
    }

    /**
     * 导入内容问题列表
     */
    @PostMapping("/importData/{dcwjId}")
    public AjaxResult importData(MultipartFile file,@PathVariable("dcwjId") Long dcwjId) throws Exception {
        ExcelUtil<SchoolDcwjNr> schoolDcwjNrExcelUtil = new ExcelUtil<>(SchoolDcwjNr.class);
        List<SchoolDcwjNr> dcwjNrList = schoolDcwjNrExcelUtil.importExcel(file.getInputStream());

        String message = schoolDcwjNrService.importDcwjNrListData(dcwjNrList, dcwjId);
        return AjaxResult.success(message);
    }


    /**
     * 新增或修改时，获取排序在本题之上的选择或多选题,即排讯号小于当前题目的排序,排序号一致的
     * 注：新增时，如果排序号相同，根据创建时间先后排序，后增加的排前面
     * */
    @GetMapping("/getSelectList/{dcwjId}")
    public TableDataInfo getSelectList(SchoolDcwjNr schoolDcwjNr,@PathVariable Long dcwjId)
    {
        //题目排序不能为空
        if(StringUtils.isNull(schoolDcwjNr.getNrPx())){
            throw new ServiceException("题目排序不能为空");
        }
        schoolDcwjNr.setDcwjId(dcwjId);

        startPage();
        //查出对应问卷的内容
        List<SchoolDcwjNr> dcwjNrList = schoolDcwjNrService.getSelectList(schoolDcwjNr);
        List<SchoolDcwjNrVo> list = new ArrayList<>();

        for (SchoolDcwjNr dcwjNr:dcwjNrList) {
            SchoolDcwjNrVo schoolDcwjNrVo = new SchoolDcwjNrVo();
            schoolDcwjNrVo.setId(dcwjNr.getId());
            schoolDcwjNrVo.setDcwjId(dcwjNr.getDcwjId());
            schoolDcwjNrVo.setNrBt(dcwjNr.getNrBt());
            schoolDcwjNrVo.setNrLx(dcwjNr.getNrLx());
            schoolDcwjNrVo.setNrPx(dcwjNr.getNrPx());
            schoolDcwjNrVo.setNrSfbt(dcwjNr.getNrSfbt());

            String nr = "";
            if (StringUtils.isNotNull(dcwjNr.getNrA()) && !("".equals(dcwjNr.getNrA()))){
                nr = nr+"选项A:"+dcwjNr.getNrA()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrB())&& !("".equals(dcwjNr.getNrB()))){
                nr = nr+" 选项B:"+dcwjNr.getNrB()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrC())&& !("".equals(dcwjNr.getNrC()))){
                nr = nr+" 选项C:"+dcwjNr.getNrC()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrD())&& !("".equals(dcwjNr.getNrD()))){
                nr = nr+" 选项D:"+dcwjNr.getNrD()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrE())&& !("".equals(dcwjNr.getNrE()))){
                nr = nr+" 选项E:"+dcwjNr.getNrE()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrF())&& !("".equals(dcwjNr.getNrF()))){
                nr = nr+" 选项F:"+dcwjNr.getNrF()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrG())&& !("".equals(dcwjNr.getNrG()))){
                nr = nr+" 选项G:"+dcwjNr.getNrG()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrH())&& !("".equals(dcwjNr.getNrH()))){
                nr = nr+" 选项H:"+dcwjNr.getNrH()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrI())&& !("".equals(dcwjNr.getNrI()))){
                nr = nr+"选项I:"+dcwjNr.getNrI()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrJ())&& !("".equals(dcwjNr.getNrJ()))){
                nr = nr+" 选项J:"+dcwjNr.getNrJ()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrK())&& !("".equals(dcwjNr.getNrK()))){
                nr = nr+" 选项K:"+dcwjNr.getNrK()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrL())&& !("".equals(dcwjNr.getNrL()))){
                nr = nr+" 选项L:"+dcwjNr.getNrL()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrM())&& !("".equals(dcwjNr.getNrM()))){
                nr = nr+" 选项M:"+dcwjNr.getNrM()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrN())&& !("".equals(dcwjNr.getNrN()))){
                nr = nr+" 选项N:"+dcwjNr.getNrN()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrO())&& !("".equals(dcwjNr.getNrO()))){
                nr = nr+" 选项O:"+dcwjNr.getNrO()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrP()) && !("".equals(dcwjNr.getNrP()))){
                nr = nr+"选项P:"+dcwjNr.getNrP()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrQ())&& !("".equals(dcwjNr.getNrQ()))){
                nr = nr+" 选项Q:"+dcwjNr.getNrQ()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrR())&& !("".equals(dcwjNr.getNrR()))){
                nr = nr+" 选项R:"+dcwjNr.getNrR()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrS())&& !("".equals(dcwjNr.getNrS()))){
                nr = nr+" 选项S:"+dcwjNr.getNrS()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrT())&& !("".equals(dcwjNr.getNrT()))){
                nr = nr+" 选项T:"+dcwjNr.getNrT()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrU())&& !("".equals(dcwjNr.getNrU()))){
                nr = nr+" 选项U:"+dcwjNr.getNrU()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrV())&& !("".equals(dcwjNr.getNrV()))){
                nr = nr+" 选项V:"+dcwjNr.getNrV()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrW())&& !("".equals(dcwjNr.getNrW()))){
                nr = nr+" 选项W:"+dcwjNr.getNrW()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrX())&& !("".equals(dcwjNr.getNrX()))){
                nr = nr+"选项X:"+dcwjNr.getNrX()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrY())&& !("".equals(dcwjNr.getNrY()))){
                nr = nr+" 选项Y:"+dcwjNr.getNrY()+ ";";
            }
            if (StringUtils.isNotNull(dcwjNr.getNrZ())&& !("".equals(dcwjNr.getNrZ()))){
                nr = nr+" 选项Z:"+dcwjNr.getNrZ()+ ";";
            }
            schoolDcwjNrVo.setNr(nr);

            list.add(schoolDcwjNrVo);
        }
        return getTaskTable(list,dcwjNrList.size());
    }

    /**题目关联-获取选项*/
    @GetMapping(value = "/getSelect/{id}")
    public AjaxResult getSelect(@PathVariable("id") Long id)
    {
        HashMap<String,String> map = new HashMap<>();
        SchoolDcwjNr dcwjNr = schoolDcwjNrService.getById(id);
        if (StringUtils.isNotNull(dcwjNr.getNrA()) && !("".equals(dcwjNr.getNrA()))){
            map.put("A", dcwjNr.getNrA());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrB())&& !("".equals(dcwjNr.getNrB()))){
            map.put("B", dcwjNr.getNrB());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrC())&& !("".equals(dcwjNr.getNrC()))){
            map.put("C", dcwjNr.getNrC());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrD())&& !("".equals(dcwjNr.getNrD()))){
            map.put("D", dcwjNr.getNrD());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrE())&& !("".equals(dcwjNr.getNrE()))){
            map.put("E", dcwjNr.getNrE());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrF())&& !("".equals(dcwjNr.getNrF()))){
            map.put("F", dcwjNr.getNrF());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrG())&& !("".equals(dcwjNr.getNrG()))){
            map.put("G", dcwjNr.getNrG());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrH())&& !("".equals(dcwjNr.getNrH()))){
            map.put("H", dcwjNr.getNrH());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrI())&& !("".equals(dcwjNr.getNrI()))){
            map.put("I", dcwjNr.getNrI());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrJ())&& !("".equals(dcwjNr.getNrJ()))){
            map.put("J", dcwjNr.getNrJ());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrK())&& !("".equals(dcwjNr.getNrK()))){
            map.put("K", dcwjNr.getNrK());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrL())&& !("".equals(dcwjNr.getNrL()))){
            map.put("L", dcwjNr.getNrL());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrM())&& !("".equals(dcwjNr.getNrM()))){
            map.put("M", dcwjNr.getNrM());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrN())&& !("".equals(dcwjNr.getNrN()))){
            map.put("N", dcwjNr.getNrN());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrO())&& !("".equals(dcwjNr.getNrO()))){
            map.put("O", dcwjNr.getNrO());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrP()) && !("".equals(dcwjNr.getNrP()))){
            map.put("P", dcwjNr.getNrP());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrQ())&& !("".equals(dcwjNr.getNrQ()))){
            map.put("Q", dcwjNr.getNrQ());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrR())&& !("".equals(dcwjNr.getNrR()))){
            map.put("R", dcwjNr.getNrR());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrS())&& !("".equals(dcwjNr.getNrS()))){
            map.put("S", dcwjNr.getNrS());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrT())&& !("".equals(dcwjNr.getNrT()))){
            map.put("T", dcwjNr.getNrT());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrU())&& !("".equals(dcwjNr.getNrU()))){
            map.put("U", dcwjNr.getNrU());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrV())&& !("".equals(dcwjNr.getNrV()))){
            map.put("V", dcwjNr.getNrV());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrW())&& !("".equals(dcwjNr.getNrW()))){
            map.put("W", dcwjNr.getNrW());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrX())&& !("".equals(dcwjNr.getNrX()))){
            map.put("X", dcwjNr.getNrX());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrY())&& !("".equals(dcwjNr.getNrY()))){
            map.put("Y", dcwjNr.getNrY());
        }
        if (StringUtils.isNotNull(dcwjNr.getNrZ())&& !("".equals(dcwjNr.getNrZ()))){
            map.put("Z", dcwjNr.getNrZ());
        }

        return AjaxResult.success(map);
    }

    /**
     * 获取内容问题详细信息
     * 若A-Z值为""则改为null
     */
    @GetMapping(value = "/queryById/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        SchoolDcwjNr nr = schoolDcwjNrService.getById(id);
        if("".equals(nr.getNrA())){
            nr.setNrA(null);
        }
        if("".equals(nr.getNrB())){
            nr.setNrB(null);
        }
        if("".equals(nr.getNrC())){
            nr.setNrC(null);
        }
        if("".equals(nr.getNrD())){
            nr.setNrD(null);
        }
        if("".equals(nr.getNrE())){
            nr.setNrE(null);
        }
        if("".equals(nr.getNrF())){
            nr.setNrF(null);
        }
        if("".equals(nr.getNrG())){
            nr.setNrG(null);
        }
        if("".equals(nr.getNrH())){
            nr.setNrH(null);
        }
        if("".equals(nr.getNrI())){
            nr.setNrI(null);
        }
        if("".equals(nr.getNrJ())){
        nr.setNrJ(null);
         }
        if("".equals(nr.getNrK())){
            nr.setNrK(null);
        }
        if("".equals(nr.getNrL())){
            nr.setNrL(null);
        }
        if("".equals(nr.getNrM())){
            nr.setNrM(null);
        }
        if("".equals(nr.getNrN())){
            nr.setNrN(null);
        }
        if("".equals(nr.getNrO())){
            nr.setNrO(null);
        }
        if("".equals(nr.getNrP())){
            nr.setNrP(null);
        }
        if("".equals(nr.getNrQ())){
            nr.setNrQ(null);
        }
        if("".equals(nr.getNrR())){
            nr.setNrR(null);
        }
        if("".equals(nr.getNrS())){
            nr.setNrS(null);
        }
        if("".equals(nr.getNrT())){
            nr.setNrT(null);
        }
        if("".equals(nr.getNrU())){
            nr.setNrU(null);
        }
        if("".equals(nr.getNrV())){
            nr.setNrV(null);
        }
        if("".equals(nr.getNrW())){
            nr.setNrW(null);
        }
        if("".equals(nr.getNrX())){
            nr.setNrX(null);
        }
        if("".equals(nr.getNrY())){
            nr.setNrY(null);
        }
        if("".equals(nr.getNrZ())){
            nr.setNrZ(null);
        }
        return AjaxResult.success(nr);
        //return AjaxResult.success(schoolDcwjNrService.queryById(id));
    }

    /**
     * 新增内容问题
     */
    @Log(title = "内容问题", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolDcwjNr schoolDcwjNr)
    {
        judgePx(schoolDcwjNr);
        schoolDcwjNr.insert();
        return toAjax(schoolDcwjNrService.insertSchoolDcwjNr(schoolDcwjNr));
    }

    /**
     * 修改内容问题
     */
    @Log(title = "内容问题", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolDcwjNr schoolDcwjNr)
    {
        if(StringUtils.isNull(schoolDcwjNr.getId())){
            throw new ServiceException("id为空");
        }
        judgePx(schoolDcwjNr);
        //存在这种情况，如果之前类型是选择题或者多选题，并且选项存在内容，当修改类型为填空或者图片时，选项还在，应删除
        if(TIANKONG.equals(schoolDcwjNr.getNrLx()) || PIC.equals(schoolDcwjNr.getNrLx())){
            LambdaUpdateWrapper<SchoolDcwjNr> luw = new LambdaUpdateWrapper<>();
            luw.eq(SchoolDcwjNr::getId,schoolDcwjNr.getId())
                    .set(SchoolDcwjNr::getDcwjId,schoolDcwjNr.getDcwjId())
                    .set(SchoolDcwjNr::getNrBt,schoolDcwjNr.getNrBt())
                    .set(SchoolDcwjNr::getNrLx,schoolDcwjNr.getNrLx())
                    .set(SchoolDcwjNr::getNrSfbt,schoolDcwjNr.getNrSfbt())
                    .set(SchoolDcwjNr::getNrPx,schoolDcwjNr.getNrPx())
                    .set(SchoolDcwjNr::getNrA,null)
                    .set(SchoolDcwjNr::getNrB,null)
                    .set(SchoolDcwjNr::getNrC,null)
                    .set(SchoolDcwjNr::getNrD,null)
                    .set(SchoolDcwjNr::getNrE,null)
                    .set(SchoolDcwjNr::getNrF,null)
                    .set(SchoolDcwjNr::getNrG,null)
                    .set(SchoolDcwjNr::getNrH,null)
                    .set(SchoolDcwjNr::getNrI,null)
                    .set(SchoolDcwjNr::getNrJ,null)
                    .set(SchoolDcwjNr::getNrK,null)
                    .set(SchoolDcwjNr::getNrL,null)
                    .set(SchoolDcwjNr::getNrM,null)
                    .set(SchoolDcwjNr::getNrN,null)
                    .set(SchoolDcwjNr::getNrO,null);
            //判断是否有页面逻辑,如果没有，则要将表里的值（如果之前有）去掉
            if(StringUtils.isNull(schoolDcwjNr.getNrId())) {
                luw.set(SchoolDcwjNr::getNrId,null).set(SchoolDcwjNr::getNrSelect,null);
            }else {
                luw.set(SchoolDcwjNr::getNrId,schoolDcwjNr.getNrId()).set(SchoolDcwjNr::getNrSelect,schoolDcwjNr.getNrSelect());
            }
            return toAjax(schoolDcwjNrService.update(luw));
        }
        return toAjax(schoolDcwjNrService.updateSchoolDcwjNr(schoolDcwjNr));
    }

    public void judgePx(SchoolDcwjNr schoolDcwjNr){
        if(StringUtils.isNull(schoolDcwjNr.getDcwjId())){
            throw new ServiceException("主表id为空,请检查");
        }
        LambdaQueryWrapper<SchoolDcwjNr> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolDcwjNr::getDcwjId,schoolDcwjNr.getDcwjId());
        List<SchoolDcwjNr> list = schoolDcwjNrService.list(lqw);
        for(SchoolDcwjNr nr : list){
            if(nr.getNrPx().equals(schoolDcwjNr.getNrPx())){
                if(StringUtils.isNotNull(schoolDcwjNr.getId()) && nr.getId().equals(schoolDcwjNr.getId())){
                    continue;
                }
                throw new ServiceException("排序不允许重复");
            }
        }
    }

    /**
     * 删除内容问题
     */
    @Log(title = "内容问题", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        //当所选删除题目为某些题目所选关联题目时，不允许删除
        for(Long id : ids){
            if (schoolDcwjNrService.hasRelationById(id))
            {
                SchoolDcwjNr nr = schoolDcwjNrService.getById(id);
                return AjaxResult.error("排序为"+ nr.getNrPx() +"的题目被其他题目关联,不允许删除");
            }
        }
        return toAjax(schoolDcwjNrService.removeByIds(ids));
    }

    /**
     * 删除所有页面逻辑
     * */
    @PutMapping("/deleteAllLogic/{dcwjId}")
    public AjaxResult deleteAllLogic(@PathVariable Long dcwjId)
    {
        return toAjax(schoolDcwjNrService.deleteAllLogic(dcwjId));
    }
}
