package yangtz.cs.liu.campus.controller.schoolCurriculum;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolCurriculum.SchoolCurriculum;
import yangtz.cs.liu.campus.service.schoolCurriculum.ISchoolCurriculumService;
import java.util.List;

@RestController
@RequestMapping("/curriculum")
public class SchoolCurriculumController extends BaseController {
    @Autowired
    private ISchoolCurriculumService schoolCurriculumService;

    /**
     * 查询课程字典列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolCurriculum schoolCurriculum)
    {
        List<SchoolCurriculum> list = schoolCurriculumService.list();
        return getDataTable(list);
    }

    /**
     * 获取课程字典详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:curriculum:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolCurriculumService.getById(id));
    }

    /**
     * 新增课程字典
     */
    @PreAuthorize("@ss.hasPermi('system:curriculum:add')")
    @PostMapping
    public AjaxResult add(@RequestBody SchoolCurriculum schoolCurriculum)
    {
        return toAjax(schoolCurriculumService.save(schoolCurriculum));
    }

    /**
     * 修改课程字典
     */
    @PreAuthorize("@ss.hasPermi('system:curriculum:edit')")
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolCurriculum schoolCurriculum)
    {
        return toAjax(schoolCurriculumService.updateById(schoolCurriculum));
    }

    /**
     * 删除课程字典
     */
    @PreAuthorize("@ss.hasPermi('system:curriculum:remove')")
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(schoolCurriculumService.removeByIds(ids));
    }
}
