package yangtz.cs.liu.campus.controller.schoolClass;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassMentor;
import yangtz.cs.liu.campus.domain.schoolCurriculum.SchoolCurriculum;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassMentorService;
import yangtz.cs.liu.campus.service.schoolCurriculum.ISchoolCurriculumService;
import yangtz.cs.liu.campus.vo.schoolClass.SchoolClassMentorVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

@RestController
@RequestMapping("/schoolClassMentor")
public class SchoolClassMentorController extends BaseController {

    @Autowired
    private ISchoolClassMentorService schoolClassMentorService;

    @Autowired
    private ISchoolCurriculumService curriculumService;


    /**
     * 查询老师
     *
     * @param schoolClassMentorVo
     * @return
     */
    @GetMapping("/list/{classId}")
    public TableDataInfo list(@PathVariable("classId") Long classId, SchoolClassMentorVo schoolClassMentorVo) {
            startPage();
            schoolClassMentorVo.setClassId(classId);
            List<SchoolClassMentorVo> list = schoolClassMentorService.selectSchoolClassMentorList(schoolClassMentorVo);
            return getDataTable(list);
    }

    /**
     * 查询单个
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        SchoolClassMentorVo schoolClassMentorVo = schoolClassMentorService.selectSchoolClassMentorById(id);
        return AjaxResult.success(schoolClassMentorVo);
    }

    /**
     * 添加老师
     *
     * @param schoolClassMentor
     * @return
     */
    @PostMapping("/add/{classId}")
    public AjaxResult addSave(@PathVariable("classId") Long classId, @RequestBody @Validated SchoolClassMentor schoolClassMentor) {
        /**
         * eidt on 2022-10-30
         * 新增教师时判断教师是否已经存在班级中
         */
        schoolClassMentor.setClassId(classId);
        judgeTeacher(schoolClassMentor);
        judgeCurriculum(schoolClassMentor);
        SchoolCurriculum curriculum = curriculumService.getById(schoolClassMentor.getCourseId());
        schoolClassMentor.setCourseName(curriculum.getCourseName());
        schoolClassMentor.setStartTime(DateUtils.getNowDate());
        return toAjax(schoolClassMentorService.save(schoolClassMentor));
    }


    /**
     * 编辑老师
     *
     * @param schoolClassMentor
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult editSave( @RequestBody @Validated SchoolClassMentor schoolClassMentor) {
        if (StringUtils.isNull(schoolClassMentor.getId()) || StringUtils.isNull(schoolClassMentor.getClassId())) {
            throw new ServiceException("修改主键id不能为空");
        }
        judgeCurriculum(schoolClassMentor);
        SchoolCurriculum curriculum = curriculumService.getById(schoolClassMentor.getCourseId());
        schoolClassMentor.setCourseName(curriculum.getCourseName());
        return toAjax(schoolClassMentorService.updateById(schoolClassMentor));
    }


    /**
     * 删除老师
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/remove/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids) {
            //删除授课教师与班级关系,设置结束时间
            for(Long id : ids){
                SchoolClassMentor mentor = schoolClassMentorService.getById(id);
                mentor.setEndTime(DateUtils.getNowDate());
                mentor.update();
                schoolClassMentorService.updateById(mentor);
            }
        return toAjax(schoolClassMentorService.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param response
     */
    @PostMapping("/schoolClassMentor/{classId}")
    public void exportAll(@PathVariable("classId") Long classId, HttpServletResponse response) {
        SchoolClassMentorVo schoolClassMentorVo = new SchoolClassMentorVo();
        schoolClassMentorVo.setClassId(classId);
        List<SchoolClassMentorVo> list = schoolClassMentorService.selectSchoolClassMentorList(schoolClassMentorVo);
        ExcelUtil<SchoolClassMentorVo> util = new ExcelUtil<>(SchoolClassMentorVo.class);
        util.exportExcel(response, list, "任课教师列表");
    }

    /**
     * 判断当前班级是否已选择该教师
     */
    public void judgeTeacher(SchoolClassMentor classMentor){
        LambdaQueryWrapper<SchoolClassMentor> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolClassMentor::getClassId, classMentor.getClassId()).eq(SchoolClassMentor::getTeacherId, classMentor.getTeacherId());
        SchoolClassMentor mentor = schoolClassMentorService.getOne(lqw);
        if (StringUtils.isNotNull(mentor)) {
            throw new ServiceException("当前教师已存在该班级中");
        }
    }

    /**
     * 判断当前班级是否已选择改
     */
    public void judgeCurriculum(SchoolClassMentor classMentor){
        LambdaQueryWrapper<SchoolClassMentor> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolClassMentor::getClassId, classMentor.getClassId()).eq(SchoolClassMentor::getCourseId, classMentor.getCourseId());
        SchoolClassMentor mentor = schoolClassMentorService.getOne(lqw);
        if (StringUtils.isNotNull(mentor)) {
            SchoolCurriculum curriculum = curriculumService.getById(mentor.getCourseId());
            throw new ServiceException("当前班级已存在"+ curriculum.getCourseName()+"的教师");
        }
    }
}


