package yangtz.cs.liu.campus.controller.schoolAuthority;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.message.SchoolMessagePush;
import yangtz.cs.liu.campus.domain.schoolAuthority.SchoolAuthority;
import yangtz.cs.liu.campus.service.impl.SchoolAuthority.WebSocketServer;
import yangtz.cs.liu.campus.service.schoolAuthority.ISchoolAuthorityService;

import javax.websocket.Session;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/school/authority")
public class SchoolAuthorityController extends BaseController {
    @Autowired
    private ISchoolAuthorityService authorityService;

    /**
     * 查询权限控制列表
     */
    @GetMapping("/list")
    public AjaxResult list(SchoolAuthority schoolAuthority)
    {
        startPage();
        List<SchoolAuthority> list = authorityService.list();
        return AjaxResult.success(list.get(0));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolAuthority authority)
    {
        if (StringUtils.isBlank(authority.getGrade())) {
            return AjaxResult.error("级部状态为空");
        }
        if (StringUtils.isBlank(authority.getClassHeader())) {
            return AjaxResult.error("班主任状态为空");
        }
        if (StringUtils.isBlank(authority.getParent())) {
            return AjaxResult.error("家长状态为空");
        }

        LambdaUpdateWrapper<SchoolAuthority> luw = new LambdaUpdateWrapper<>();
        luw
                .set(SchoolAuthority::getGrade, authority.getGrade())
                .set(SchoolAuthority::getClassHeader, authority.getClassHeader())
                .set(SchoolAuthority::getParent, authority.getParent());
        boolean flag = authorityService.update(luw);
        if(flag){
            JSONObject result = new JSONObject();
            JSONArray array = new JSONArray();
            result.set("users", array);
            JSONObject jsonObject1 = new JSONObject();
            jsonObject1.set("grade", authority.getGrade());
            JSONObject jsonObject2 = new JSONObject();
            jsonObject2.set("classHeader", authority.getClassHeader());
            JSONObject jsonObject3 = new JSONObject();
            jsonObject3.set("parent", authority.getParent());

            array.add(jsonObject1);
            array.add(jsonObject2);
            array.add(jsonObject3);
            WebSocketServer.sendMessage(JSONUtil.toJsonStr(result));
        }
        return toAjax(flag);
    }

    /**
     * 级部修改权限控制
     */
    @PutMapping("/editGrade")
    public AjaxResult editGrade(String grade)
    {
        if (StringUtils.isBlank(grade)) {
            return AjaxResult.error("修改状态失败");
        }
        LambdaUpdateWrapper<SchoolAuthority> luw = new LambdaUpdateWrapper<>();
        luw.set(SchoolAuthority::getGrade, grade);
        return toAjax(authorityService.update(luw));
    }

    /**
     * 班主任修改权限控制
     */
    @PutMapping("/editClassHeader")
    public AjaxResult editClassHeader(String classHeader)
    {
        if (StringUtils.isBlank(classHeader)) {
            return AjaxResult.error("修改状态失败");
        }
        LambdaUpdateWrapper<SchoolAuthority> luw = new LambdaUpdateWrapper<>();
        luw.set(SchoolAuthority::getClassHeader, classHeader);
        return toAjax(authorityService.update(luw));
    }

    /**
     * 家长端修改权限控制
     */
    @PutMapping("/editParent")
    public AjaxResult editParent(String parent)
    {
        if (StringUtils.isBlank(parent)) {
            return AjaxResult.error("修改状态失败");
        }
        LambdaUpdateWrapper<SchoolAuthority> luw = new LambdaUpdateWrapper<>();
        luw.set(SchoolAuthority::getParent, parent);
        return toAjax(authorityService.update(luw));
    }
}
