package yangtz.cs.liu.campus.controller.schoolAssets;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysUserService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.common.core.controller.BaseController;
import yangtz.cs.liu.campus.domain.schoolAssets.SchoolAssetsEnter;
import yangtz.cs.liu.campus.domain.schoolAssets.SchoolAssetsOut;
import yangtz.cs.liu.campus.domain.schoolAssetsClaim.SchoolAssetsClaim;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsOutService;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsService;
import yangtz.cs.liu.campus.vo.schoolAssets.AssetsOutVo;
import yangtz.cs.liu.campus.vo.schoolAssets.SchoolAssetsOutVo;

import java.util.List;


/**
 * 【请填写功能名称】Controller
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@RestController
@RequestMapping("/schoolAssetsOut")
public class SchoolAssetsOutController extends BaseController {
    @Autowired
    private ISchoolAssetsOutService schoolAssetsOutService;
    @Autowired
    private ISchoolAssetsService schoolAssetsService;
    @Autowired
    private ISysUserService userService;

    /**
     * 新增出库
     */
    @PostMapping("/add")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult add(@RequestBody @Validated SchoolAssetsOut schoolAssetsOut) {
        schoolAssetsOutService.save(schoolAssetsOut);
        //库存数量减少
        return toAjax(schoolAssetsService.reduceAssets(schoolAssetsOut.getAssetsId(), schoolAssetsOut.getOutNumbers()));
    }

    /**
     * id查询物品出库记录
     */
    @GetMapping("/queryInfo/{id}")
    public AjaxResult queryInfo(@PathVariable Long id) {
        AssetsOutVo vo = new AssetsOutVo();
        SchoolAssetsOut out = schoolAssetsOutService.getById(id);
        BeanUtils.copyProperties(out,vo);
        SysUser user = userService.selectUserById(out.getOutBy());
        if(StringUtils.isNotNull(user)){
            vo.setOutByName(user.getUserName());
        }
        return AjaxResult.success(vo);
    }


    /**
     * 修改出库
     */
    @PostMapping("/edit")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult edit(@RequestBody @Validated SchoolAssetsOut schoolAssetsOut) {
        Integer oldNum = schoolAssetsOutService.getById(schoolAssetsOut.getId()).getOutNumbers(); //原来出库数量
        schoolAssetsOutService.updateById(schoolAssetsOut);  //修改出库记录
        Integer newNum = schoolAssetsOut.getOutNumbers(); //新的出库数量
        //库存数量更新
        return toAjax(schoolAssetsService.updateOutAssets(schoolAssetsOut.getAssetsId(), oldNum, newNum));
    }

    /**
     * 删除入库
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {
        try {
            for (Long id : ids) {
                Integer number = schoolAssetsOutService.getById(id).getOutNumbers();
                Long assetsId = schoolAssetsOutService.getById(id).getAssetsId();
                schoolAssetsOutService.removeById(id); //出库记录删除
                schoolAssetsService.addAssets(assetsId, number);  //库存记录数量增加
            }
            return AjaxResult.success("删除成功");
        } catch (Exception e) {
            throw new ServiceException("删除失败");
        }
    }

    /**
     * 查询物品出库记录列表
     */
    @GetMapping("/list/{assetsId}")
    public TableDataInfo list(@PathVariable Long assetsId,SchoolAssetsOutVo schoolAssetsOutVo) {
        schoolAssetsOutVo.setAssetsId(assetsId);
        startPage();
        List<AssetsOutVo> list = schoolAssetsOutService.queryList(schoolAssetsOutVo);
        return getDataTable(list);
    }
}
