package yangtz.cs.liu.campus.controller.schoolAnnualAssessment;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysDeptService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolAnnualAssessment.SchoolAnnualAssessment;
import yangtz.cs.liu.campus.domain.schoolAnnualAssessment.SchoolAnnualAssessmentExport;
import yangtz.cs.liu.campus.service.schoolAnnualAssessment.ISchoolAnnualAssessmentService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteachingAchievementsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;
import yangtz.cs.liu.campus.vo.schoolAnnualAssessment.SchoolAnnualAssessmentVo;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXteachingAchievementsVo;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 年度考核Controller
 *
 * @author ruoyi
 * @date 2023-12-05
 */
@RestController
@RequestMapping("/school/annualAssessment")
public class SchoolAnnualAssessmentController extends BaseController {

    @Autowired
    private ISchoolAnnualAssessmentService schoolAnnualAssessmentService;
    @Autowired
    private ISchoolXteachingAchievementsService schoolXteachingAchievementsService;
    @Autowired
    private ISysDeptService sysDeptService;
    @Autowired
    private SchoolTeacherBasichlnformationService basichlnformationService;

    /**
     * 查询年度考核列表
     */
//    @PreAuthorize("@ss.hasPermi('school:annualAssessment:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolAnnualAssessmentVo schoolAnnualAssessmentVo)
    {

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            startPage();
            List<SchoolAnnualAssessment> list = schoolAnnualAssessmentService.selectSchoolAnnualAssessmentList(schoolAnnualAssessmentVo);
            return getDataTable(list);
        }

        //全部权限
        List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("ndkh_admin")).collect(Collectors.toList());
        if (roleList.size() > 0){
            startPage();
            List<SchoolAnnualAssessment> list = schoolAnnualAssessmentService.selectSchoolAnnualAssessmentList(schoolAnnualAssessmentVo);
            return getDataTable(list);
        }
        //部分权限
        List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
        if (roleList1.size() > 0){
            //教师电子档案中级管理员只能查看本部门及部门以下的数据
            //根据用户部门id查询用户部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            //获取当前登陆人部门下所有人的手机号
            List<String> userPhones = schoolXteachingAchievementsService.getUserPhonesByDeptId(sysDept.getDeptId());
            //根据用户手机号查询用户身份证信息
            List<String> userIdCards = basichlnformationService.selectIdCardsByDdPhone(userPhones);
            if (userIdCards.size() > 0){
                schoolAnnualAssessmentVo.setIdCards(userIdCards);
            }
            startPage();
            List<SchoolAnnualAssessment> list = schoolAnnualAssessmentService.selectSchoolAnnualAssessmentList(schoolAnnualAssessmentVo);
            return getDataTable(list);
        }
        return getDataTable(new ArrayList<>());
    }

    /**
     * 导出年度考核列表
     */
//    @PreAuthorize("@ss.hasPermi('school:annualAssessment:export')")
    @Log(title = "年度考核", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolAnnualAssessmentVo schoolAnnualAssessmentVo)
    {
        int i = 0;

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            List<SchoolAnnualAssessment> list = schoolAnnualAssessmentService.selectSchoolAnnualAssessmentList(schoolAnnualAssessmentVo);
            List<SchoolAnnualAssessmentVo> exportList = new ArrayList<>();
            for (SchoolAnnualAssessment annualAssessment : list) {
                i ++;
                //转vo
                SchoolAnnualAssessmentVo schoolAnnualAssessmentVo1 = new SchoolAnnualAssessmentVo();
                BeanUtils.copyProperties(annualAssessment,schoolAnnualAssessmentVo1);
                schoolAnnualAssessmentVo1.setXh(i);
                exportList.add(schoolAnnualAssessmentVo1);
            }
            ExcelUtil<SchoolAnnualAssessmentVo> util = new ExcelUtil<SchoolAnnualAssessmentVo>(SchoolAnnualAssessmentVo.class);
            util.exportExcel(response, exportList, "年度考核数据");
        }

        //全部权限
        List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("ndkh_admin")).collect(Collectors.toList());
        if (roleList.size() > 0){
            List<SchoolAnnualAssessment> list = schoolAnnualAssessmentService.selectSchoolAnnualAssessmentList(schoolAnnualAssessmentVo);
            List<SchoolAnnualAssessmentVo> exportList = new ArrayList<>();
            for (SchoolAnnualAssessment annualAssessment : list) {
                i ++;
                //转vo
                SchoolAnnualAssessmentVo schoolAnnualAssessmentVo1 = new SchoolAnnualAssessmentVo();
                BeanUtils.copyProperties(annualAssessment,schoolAnnualAssessmentVo1);
                schoolAnnualAssessmentVo1.setXh(i);
                exportList.add(schoolAnnualAssessmentVo1);
            }
            ExcelUtil<SchoolAnnualAssessmentVo> util = new ExcelUtil<SchoolAnnualAssessmentVo>(SchoolAnnualAssessmentVo.class);
            util.exportExcel(response, exportList, "年度考核数据");
        }
        //部分权限
        List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
        if (roleList1.size() > 0){
            //教师电子档案中级管理员只能查看本部门及部门以下的数据
            //根据用户部门id查询用户部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            //获取当前登陆人部门下所有人的手机号
            List<String> userPhones = schoolXteachingAchievementsService.getUserPhonesByDeptId(sysDept.getDeptId());
            //根据用户手机号查询用户身份证信息
            List<String> userIdCards = basichlnformationService.selectIdCardsByDdPhone(userPhones);
            if (userIdCards.size() > 0){
                schoolAnnualAssessmentVo.setIdCards(userIdCards);
            }
            List<SchoolAnnualAssessment> list = schoolAnnualAssessmentService.selectSchoolAnnualAssessmentList(schoolAnnualAssessmentVo);
            List<SchoolAnnualAssessmentVo> exportList = new ArrayList<>();
            for (SchoolAnnualAssessment annualAssessment : list) {
                i ++;
                //转vo
                SchoolAnnualAssessmentVo schoolAnnualAssessmentVo1 = new SchoolAnnualAssessmentVo();
                BeanUtils.copyProperties(annualAssessment,schoolAnnualAssessmentVo1);
                schoolAnnualAssessmentVo1.setXh(i);
                exportList.add(schoolAnnualAssessmentVo1);
            }
            ExcelUtil<SchoolAnnualAssessmentVo> util = new ExcelUtil<SchoolAnnualAssessmentVo>(SchoolAnnualAssessmentVo.class);
            util.exportExcel(response, exportList, "年度考核数据");
        }else{
            ExcelUtil<SchoolAnnualAssessmentVo> util = new ExcelUtil<SchoolAnnualAssessmentVo>(SchoolAnnualAssessmentVo.class);
            util.exportExcel(response, new ArrayList<>(), "年度考核数据");
        }
    }

    /*
     * 下载模板
     * */
    @PostMapping("/importTemplate")
    public void importTemplate (HttpServletResponse response) {
        schoolAnnualAssessmentService.importTemplate(response);
    }

    /**
     * 导入年度考核数据
     * @param file
     * @return
     * @throws Exception
     */
//    @PreAuthorize("@ss.hasPermi('school:annualAssessment:importData')")
    @PostMapping("/importData")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult importData(MultipartFile file) throws Exception {
        ExcelUtil<SchoolAnnualAssessment> util = new ExcelUtil<SchoolAnnualAssessment>(SchoolAnnualAssessment.class);
        List<SchoolAnnualAssessment> list = util.importExcelNdkh(file.getInputStream());
        //先校验
        schoolAnnualAssessmentService.checkImport(list);
        //数据导入
        String message = schoolAnnualAssessmentService.importData(list);
        return AjaxResult.success(message);
    }

    /**
     * 获取年度考核详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolAnnualAssessmentService.selectSchoolAnnualAssessmentById(id));
    }

    /**
     * 新增年度考核
     */
//    @PreAuthorize("@ss.hasPermi('school:annualAssessment:add')")
    @Log(title = "年度考核", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolAnnualAssessment schoolAnnualAssessment)
    {
        return toAjax(schoolAnnualAssessmentService.insertSchoolAnnualAssessment(schoolAnnualAssessment));
    }

    /**
     * 修改年度考核
     */
//    @PreAuthorize("@ss.hasPermi('school:annualAssessment:edit')")
    @Log(title = "年度考核", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolAnnualAssessment schoolAnnualAssessment)
    {
        return toAjax(schoolAnnualAssessmentService.updateSchoolAnnualAssessment(schoolAnnualAssessment));
    }

    /**
     * 删除年度考核
     */
//    @PreAuthorize("@ss.hasPermi('school:annualAssessment:remove')")
    @Log(title = "年度考核", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolAnnualAssessmentService.deleteSchoolAnnualAssessmentByIds(ids));
    }
}
