package yangtz.cs.liu.campus.controller.resources;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.resources.SchoolResourcesDetails;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesDetailsService;
import yangtz.cs.liu.campus.vo.resource.SchoolResourcesDetailsVo;

import java.util.List;

@RestController
@RequestMapping("/schoolResourcesDetails")
public class SchoolResourcesDetailsController extends BaseController {
    @Autowired
    private ISchoolResourcesDetailsService schoolResourcesDetailsService;


    /**
     * 查询学校资源库列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolResourcesDetailsVo schoolResourcesDetailsVo) {
        startPage();
//        schoolResourcesDetailsVo.setResourcesId(resourcesId);
        List<SchoolResourcesDetailsVo> list = schoolResourcesDetailsService.queryList(schoolResourcesDetailsVo);
        return getDataTable(list);
    }

    @GetMapping("/updateThumbsUp/{id}")
    public AjaxResult updateThumbsUp(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolResourcesDetails> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolResourcesDetails::getId, id).setSql("thumbs_up = thumbs_up + 1");
        return toAjax(schoolResourcesDetailsService.update(luw));
    }

    @GetMapping("/updateCollection/{id}")
    public AjaxResult updateCollection(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolResourcesDetails> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolResourcesDetails::getId, id).setSql("collection = collection + 1");
        return toAjax(schoolResourcesDetailsService.update(luw));
    }

    @GetMapping("/updateDownload/{id}")
    public AjaxResult updateDownload(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolResourcesDetails> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolResourcesDetails::getId, id).setSql("download = download + 1");
        return toAjax(schoolResourcesDetailsService.update(luw));
    }


    /**
     * 获取学校资源库详细信息
     */

    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolResourcesDetailsService.getById(id));
    }

    /**
     * 新增学校资源库
     */
//    此处实现异步上传，即不由后端帮助前端上传，需要由前端手动调用upload
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolResourcesDetails schoolResourcesDetails) {
        return toAjax(schoolResourcesDetailsService.save(schoolResourcesDetails));
    }

    /**
     * 修改学校资源库
     */

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolResourcesDetails schoolResourcesDetails) {
        return toAjax(schoolResourcesDetailsService.updateById(schoolResourcesDetails));
    }

    /**
     * 删除学校资源库
     */
    @DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolResourcesDetailsService.removeByIds(ids));
    }
}
