package yangtz.cs.liu.campus.controller.resources;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.resources.SchoolResources;
import yangtz.cs.liu.campus.domain.resources.SchoolResourcesDetails;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesDetailsService;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesService;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 学校资源库Controller
 *
 * @author ruoyi
 * @date 2022-09-29
 */
@RestController
@RequestMapping("/schoolResources")
public class SchoolResourcesController extends BaseController
{
    @Autowired
    private ISchoolResourcesService schoolResourcesService;

    @Autowired
    private ISchoolResourcesDetailsService schoolResourcesDetailsService;


    /**
     * 查询学校资源库列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolResources schoolResources)
    {
        startPage();
        List<SchoolResources> list = schoolResourcesService.queryList(schoolResources);
        return getDataTable(list);
    }

    /**
     * 导出学校资源库列表
     */

    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids)
    {
        List<SchoolResources> list = schoolResourcesService.listByIds(ids);
        ExcelUtil<SchoolResources> util = new ExcelUtil<>(SchoolResources.class);
        util.exportExcel(response, list, "学校资源库数据");
    }

    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolResources schoolResources)
    {
        LambdaQueryWrapper<SchoolResources> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolResources.getName()),SchoolResources::getName,schoolResources.getName())
                .orderByDesc(SchoolResources::getCreateTime)
        ;
        List<SchoolResources> list = schoolResourcesService.list(lqw);
        ExcelUtil<SchoolResources> util = new ExcelUtil<SchoolResources>(SchoolResources.class);
        util.exportExcel(response, list, "学校资源库数据");
    }




    /**
     * 获取学校资源库详细信息
     */

    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolResourcesService.getById(id));
    }

    /**
     * 新增学校资源库
     */

    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolResources schoolResources)
    {
        if (StringUtils.isEmpty(schoolResources.getResourceUrl())) {
            schoolResources.setResourceUrl("https://alifei03.cfp.cn/creative/vcg/800/new/VCG211101771115.jpg");
        }
        return toAjax(schoolResourcesService.save(schoolResources));
    }

    /**
     * 修改学校资源库
     */

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolResources schoolResources)
    {
        return toAjax(schoolResourcesService.updateById(schoolResources));
    }

    /**
     * 删除学校资源库
     */
    @DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable("ids") List<Long> ids)
    {
        LambdaQueryWrapper<SchoolResourcesDetails> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolResourcesDetails::getResourcesId, ids);
        schoolResourcesDetailsService.remove(lqw);
        return toAjax(schoolResourcesService.removeByIds(ids));
    }
}
