package yangtz.cs.liu.campus.controller.recipe;


import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.recipe.SchoolRecipes;
import yangtz.cs.liu.campus.service.recipe.ISchoolRecipesService;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;


/**
 * 学校每日食谱Controller
 *
 * @author ruoyi
 * @date 2022-10-05
 */
@RestController
@RequestMapping("/schoolRecipes")
public class SchoolRecipesController extends BaseController {
    @Autowired
    private ISchoolRecipesService schoolRecipesService;

    /**
     * 查询学校每日食谱列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolRecipes schoolRecipes) {
        startPage();
        List<SchoolRecipes> list = schoolRecipesService.queryList(schoolRecipes);
        return getDataTable(list);
    }

    /**
     * 新增学校每日食谱
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolRecipes schoolRecipes) {
        LambdaQueryWrapper<SchoolRecipes> lqw = new LambdaQueryWrapper<>();
        lqw.eq(isNotNull(schoolRecipes.getDate()), SchoolRecipes::getDate, schoolRecipes.getDate());
        SchoolRecipes recipes = schoolRecipesService.getOne(lqw);
        if (isNotNull(recipes)){
            throw new ServiceException("该日期已经存在，请检查后输入");
        }
        return toAjax(schoolRecipesService.save(schoolRecipes));
//        //获取数据库中的内容
//        List<SchoolRecipes> list = schoolRecipesService.queryList(schoolRecipes);
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//        String StringDate = sdf.format(schoolRecipes.getDate());
//        for (SchoolRecipes schoolRecipe : list) {
//            String format = sdf.format(schoolRecipe.getDate());
//            if (format.equals(StringDate)) {
//                throw new ServiceException("已经存在相同日期的食谱，请重新选择食谱日期");
//            }
//        }
    }

    /**
     * 修改学校每日食谱
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolRecipes schoolRecipes) {
            LambdaQueryWrapper<SchoolRecipes> lqw = new LambdaQueryWrapper<>();
            lqw.eq(isNotNull(schoolRecipes.getDate()), SchoolRecipes::getDate, schoolRecipes.getDate());
            SchoolRecipes recipes = schoolRecipesService.getOne(lqw);
            if (isNull(recipes)){
                throw new ServiceException("该日期已经存在，请检查后输入");
            }
//        if (StringUtils.isNull(schoolRecipes.getId())) {
//            throw new ServiceException("主键不能为空");
//        }
//        List<SchoolRecipes> list = schoolRecipesService.queryList(schoolRecipes);
//        //SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//        //String StringDate = sdf.format(schoolRecipes.getDate());
//        for (SchoolRecipes schoolRecipe : list) {
//            if (schoolRecipe.getDate().equals(schoolRecipes.getDate())) {
//                throw new ServiceException("已经存在相同日期的食谱，请重新选择食谱日期");
//            }
//        }
        return toAjax(schoolRecipesService.updateById(schoolRecipes));
    }

    /**
     * 获取学校每日食谱详细信息
     */
    @GetMapping(value = "/queryOne/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolRecipesService.getById(id));
    }

    /**
     * 删除学校每日食谱
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolRecipesService.removeByIds(ids));
    }

    /*
    根据输入的id到处对应的食谱列表
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolRecipes> list = schoolRecipesService.listByIds(ids);
        ExcelUtil<SchoolRecipes> excelUtil = new ExcelUtil<>(SchoolRecipes.class);
        excelUtil.exportExcel(response, list, "食谱");
    }

    /**
     * 导出学校每日食谱列表
     */
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolRecipes schoolRecipes) {
        LambdaQueryWrapper<SchoolRecipes> lqw = new LambdaQueryWrapper<>();
        lqw.like(isNotNull(schoolRecipes.getDate()), SchoolRecipes::getDate, schoolRecipes.getDinner())
                .like(isNotBlank(schoolRecipes.getBreakfast()), SchoolRecipes::getBreakfast, schoolRecipes.getBreakfast())
                .like(isNotBlank(schoolRecipes.getLunch()), SchoolRecipes::getLunch, schoolRecipes.getLunch())
                .like(isNotBlank(schoolRecipes.getDinner()), SchoolRecipes::getDinner, schoolRecipes.getDinner());
        List<SchoolRecipes> list = schoolRecipesService.list(lqw);
        ExcelUtil<SchoolRecipes> util = new ExcelUtil<>(SchoolRecipes.class);
        util.exportExcel(response, list, "食谱");
    }


    /**
     * 下载模板
     *
     * @param httpServletResponse
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse httpServletResponse) {
        ExcelUtil<SchoolRecipes> util = new ExcelUtil<SchoolRecipes>(SchoolRecipes.class);
        util.importTemplateExcel(httpServletResponse, "食谱数据");
    }


    /**
     * 导入数据
     *
     * @param file
     * @return
     * @throws Exception
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file) throws Exception {
        ExcelUtil<SchoolRecipes> util = new ExcelUtil<SchoolRecipes>(SchoolRecipes.class);
        List<SchoolRecipes> list = util.importExcel(file.getInputStream());
        //1.先校验
        schoolRecipesService.check(list);
        //2.导入
        String message = schoolRecipesService.importData(list);
        return AjaxResult.success(message);
    }

}
