package yangtz.cs.liu.campus.controller.patrol;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolDetails;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolDetailsService;

import java.util.List;


/**
 * 课堂巡视详细得分Controller
 */
@RestController
@RequestMapping("/schoolPatrolDetails")
public class SchoolPatrolDetailsController extends BaseController {

    @Autowired
    private ISchoolPatrolDetailsService schoolPatrolDetailsService;

    private Logger log = LoggerFactory.getLogger(SchoolPatrolDetailsController.class);

    /**
     * 课堂巡视详细得分列表
     *
     * @param schoolPatrolDetails
     * @return
     */
    @GetMapping("/list/{patrolId}")
    public TableDataInfo list(@PathVariable("patrolId") Long patrolId, SchoolPatrolDetails schoolPatrolDetails) {
        try {
            startPage();
            schoolPatrolDetails.setPatrolId(patrolId);
            List<SchoolPatrolDetails> list = schoolPatrolDetailsService.queryList(schoolPatrolDetails);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询课堂巡视详细得分时出现异常");
        }
    }

    /**
     * 新增（课堂巡检打分规则明细到课堂巡视打分表）
     *
     * @param ruleId
     * @return
     */
    @PostMapping("/addRuleDetails/{patrolId}/{ruleId}")
    public AjaxResult addRuleDetails(@PathVariable("patrolId") Long patrolId, @PathVariable("ruleId") Long ruleId) {
        return AjaxResult.success(schoolPatrolDetailsService.addRuleDetails(ruleId, patrolId));
    }


    /**
     * 更新课堂巡视详细得分
     */
    @PostMapping("/score/{ids}")
    public AjaxResult score(@PathVariable("ids") Long[] ids, Long patrolId, Long score) {

        return toAjax(schoolPatrolDetailsService.updateSchoolPatrolDetailsByIds(ids, patrolId, score));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        try {
            return toAjax(schoolPatrolDetailsService.removeByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除数据异常");
        }
    }
}
