package yangtz.cs.liu.campus.controller.patrol;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrol;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolDetails;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolDetailsService;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolService;
import yangtz.cs.liu.campus.vo.patrol.SchoolPatrolVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 课堂巡视Controller
 */
@RestController
@RequestMapping("/schoolPatrol")
public class SchoolPatrolController extends BaseController {

    @Autowired
    private ISchoolPatrolService schoolPatrolService;

    @Autowired
    private ISchoolPatrolDetailsService schoolPatrolDetailsService;

    private Logger log = LoggerFactory.getLogger(SchoolPatrolController.class);

    /**
     * 巡视列表
     *
     * @param schoolPatrol
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolPatrolVo schoolPatrol) {
        try {
            startPage();
            List<SchoolPatrolVo> list = schoolPatrolService.queryList(schoolPatrol);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询课堂巡视列表异常");
        }
    }


    /**
     * 新增
     *
     * @param schoolPatrol
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolPatrol schoolPatrol) {
        return toAjax(schoolPatrolService.save(schoolPatrol));
    }


    /**
     * 修改
     *
     * @param schoolPatrol
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolPatrol schoolPatrol) {
        if (StringUtils.isNull(schoolPatrol.getId())) {
            throw new BaseException("修改主键id不能为空");
        }
        return toAjax(schoolPatrolService.updateById(schoolPatrol));
    }


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        try {
            LambdaQueryWrapper<SchoolPatrolDetails> lqw = new LambdaQueryWrapper<>();
            lqw.in(SchoolPatrolDetails::getPatrolId, ids);
            schoolPatrolDetailsService.remove(lqw);
            return toAjax(schoolPatrolService.removeByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除数据异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolPatrolVo> list = schoolPatrolService.exportByIds(ids);
        ExcelUtil<SchoolPatrolVo> util = new ExcelUtil<>(SchoolPatrolVo.class);
        util.exportExcel(response, list, "课堂巡视表");
    }

    /**
     * 导出全部
     *
     * @param response
     * @param schoolPatrol
     */
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolPatrolVo schoolPatrol) {
        List<SchoolPatrolVo> list = schoolPatrolService.queryList(schoolPatrol);
        ExcelUtil<SchoolPatrolVo> util = new ExcelUtil<>(SchoolPatrolVo.class);
        util.exportExcel(response, list, "课堂巡视表");
    }


    /**
     * 重新打分
     *
     * @param patrolId
     * @return
     */
    @PostMapping("/rescore/{id}")
    @ResponseBody
    public AjaxResult rescore(@PathVariable("id") Long patrolId) {
        return toAjax(schoolPatrolService.rescore(patrolId));
    }

}
