package yangtz.cs.liu.campus.controller.organization;

import java.util.Arrays;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationMember;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationSignin;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationMemberService;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationSigninService;
import yangtz.cs.liu.campus.vo.organization.SigninVo;
import yangtz.cs.liu.campus.vo.organization.signinApprove2Vo;

/**
 * 社团报名审核Controller
 * 
 * @author liul
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/signin")
public class SchoolOrganizationSigninController extends BaseController
{
    @Autowired
    private ISchoolOrganizationSigninService schoolOrganizationSigninService;

    @Autowired
    private ISchoolOrganizationMemberService schoolOrganizationMemberService;

    /**
     * 查询社团报名审核列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SigninVo vo)
    {
        LambdaQueryWrapper<SchoolOrganizationSignin> wrapper = Wrappers.lambdaQuery();
        wrapper.like(StringUtils.isNotEmpty(vo.getName()),SchoolOrganizationSignin::getName,vo.getName())
                .eq(SchoolOrganizationSignin::getCid,vo.getCid())
                .eq(StringUtils.isNotEmpty(vo.getClasses()),SchoolOrganizationSignin::getClasses,vo.getClasses())
                .eq(StringUtils.isNotEmpty(vo.getGrade()),SchoolOrganizationSignin::getGrade,vo.getGrade())
                .orderByDesc(SchoolOrganizationSignin::getCreateTime);
        startPage();
        List<SchoolOrganizationSignin> list = schoolOrganizationSigninService.list(wrapper);
        return getDataTable(list);
    }

    /**
     * 获取社团报名审核详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolOrganizationSigninService.getById(id));
    }

    /**
     * 新增社团报名
     */
    /*@Log(title = "社团报名", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolOrganizationSignin schoolOrganizationSignin)
    {
        return toAjax(schoolOrganizationSigninService.save(schoolOrganizationSignin));
    }*/

    /**
     * 同意社团申请审批
     */
    @Transactional
    @PostMapping("/approve")
    public AjaxResult approve(@RequestBody signinApprove2Vo vo)
    {
        SchoolOrganizationSignin signin = schoolOrganizationSigninService.getById(vo.getId());
        SchoolOrganizationSignin so = new SchoolOrganizationSignin();
        so.setId(vo.getId());
        so.setStatus(vo.getStatus());
        //同意后还要将当前人员数据插入到社团成员表中
        if (signin!=null && StringUtils.equals(so.getStatus(),"2")){
            SchoolOrganizationMember member = new SchoolOrganizationMember();
            member.setCid(signin.getCid());
            member.setName(signin.getName());
            member.setGrade(signin.getGrade());
            member.setClasses(signin.getClasses());
            member.setOrgName(signin.getOrgName());
            member.setPhone(signin.getPhone());
            member.setSex(signin.getSex());
            member.setUserId(signin.getUserId());
            member.setCardid(signin.getCardid());
            boolean save = schoolOrganizationMemberService.save(member);
            System.out.println(save);
        }
        boolean b = schoolOrganizationSigninService.updateById(so);
        return toAjax(b);
    }

    /**
     * 修改社团报名审核
     */
   /* @Log(title = "社团报名审核", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolOrganizationSignin schoolOrganizationSignin)
    {
        return toAjax(schoolOrganizationSigninService.updateById(schoolOrganizationSignin));
    }*/

    /**
     * 删除社团报名审核
     */
    /*@Log(title = "社团报名审核", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        List<Long> list = Arrays.asList(ids);
        return toAjax(schoolOrganizationSigninService.removeByIds(list));
    }*/
}
