package yangtz.cs.liu.campus.controller.message;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.message.SchoolMessagePush;
import yangtz.cs.liu.campus.service.message.ISchoolMessagePushService;
import yangtz.cs.liu.wechat.vo.message.MessagePushVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static yangtz.cs.liu.campus.constant.MessageConstant.NORMAL;

@RestController
@RequestMapping("/schoolMessagePush")
public class SchoolMessagePushController extends BaseController {
    @Autowired
    private ISchoolMessagePushService schoolMessagePushService;

    private Logger log = LoggerFactory.getLogger(SchoolMessagePushController.class);

    /**
     * 消息列表
     *
     * @param schoolMessagePush
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolMessagePush schoolMessagePush) {
        startPage();
        List<SchoolMessagePush> list = schoolMessagePushService.queryList(schoolMessagePush);
        return getDataTable(list);
    }

    /**
     * 系统首页用户可查看消息
     * */
    @GetMapping("/teacherMessageList")
    public TableDataInfo teacherMessageList(MessagePushVO messagePushVO) {
        startPage();
        List<MessagePushVO> list = schoolMessagePushService.getList(messagePushVO);
        return getDataTable(list);
    }


    /**
     * 新增
     *
     * @param schoolMessagePush
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolMessagePush schoolMessagePush) {
        //默认正常
        schoolMessagePush.setState(NORMAL);
        return toAjax(schoolMessagePushService.savePush(schoolMessagePush));
    }

    /**
     * 修改
     *
     * @param schoolMessagePush
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolMessagePush schoolMessagePush) {
        if (StringUtils.isNull(schoolMessagePush.getId())) {
            throw new ServiceException("id为空，修改失败");
        }
        return toAjax(schoolMessagePushService.editPush(schoolMessagePush));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolMessagePushService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolMessagePushService.deletePush(ids));
    }

    /**
     * 修改状态
     */
    @PutMapping("/changeState/{id}")
    public AjaxResult changeState(@PathVariable("id") Long id, String state) {
        if (StringUtils.isBlank(state)) {
            return AjaxResult.error("修改状态失败");
        }
        LambdaUpdateWrapper<SchoolMessagePush> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolMessagePush::getId, id).set(SchoolMessagePush::getState, state);
        return toAjax(schoolMessagePushService.update(luw));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        LambdaQueryWrapper<SchoolMessagePush> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolMessagePush::getId,ids).orderByDesc(SchoolMessagePush::getCreateTime);
        List<SchoolMessagePush> list = schoolMessagePushService.list(lqw);
        ExcelUtil<SchoolMessagePush> util = new ExcelUtil<>(SchoolMessagePush.class);
        util.exportExcel(response, list, "push");
    }

    //导出全部
    @PostMapping("/exportAll")
    public void exportAll(HttpServletResponse response, SchoolMessagePush schoolMessagePush) {
        List<SchoolMessagePush> list = schoolMessagePushService.queryList(schoolMessagePush);
        ExcelUtil<SchoolMessagePush> util = new ExcelUtil<>(SchoolMessagePush.class);
        util.exportExcel(response, list, "push");
    }

}
