package yangtz.cs.liu.campus.controller.message;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.message.SchoolMessageParentsPushsDetails;
import yangtz.cs.liu.campus.service.message.ISchoolMessageParentsPushsDetailsService;
import yangtz.cs.liu.campus.vo.message.ParentsPushsDetailsVO;
import yangtz.cs.liu.campus.vo.message.PushParentVO;

/**
 * 家长消息推送详情Controller
 *
 * @author ruoyi
 * @date 2022-10-28
 */
@RestController
@RequestMapping("/parentPush/details")
public class SchoolMessageParentsPushsDetailsController extends BaseController
{
    @Autowired
    private ISchoolMessageParentsPushsDetailsService schoolMessageParentsPushsDetailsService;

    /**
     * 查询家长消息推送详情列表
     */
    @GetMapping("/list/{pushId}")
    public TableDataInfo list(@PathVariable Long pushId, ParentsPushsDetailsVO detailsVO)
    {
        startPage();
        detailsVO.setPushId(pushId);
        List<ParentsPushsDetailsVO> list = schoolMessageParentsPushsDetailsService.queryList(detailsVO);
        return getDataTable(list);
    }

    /**
     * 弹窗，选择要推送给的家长列表
     */
    @GetMapping("/parentList/{pushId}")
    public TableDataInfo teacherList(@PathVariable Long pushId, ParentsPushsDetailsVO detailsVO) {
        detailsVO.setPushId(pushId);
        startPage();
        List<PushParentVO> list = schoolMessageParentsPushsDetailsService.queryAddList(detailsVO);
        return getDataTable(list);
    }

    /**
     * 新增,挂载到当前的消息通知下
     */
    @PostMapping("/add/{pushId}/{userIds}")
    public AjaxResult add(@PathVariable Long pushId, @PathVariable List<Long> userIds) {
        return toAjax(schoolMessageParentsPushsDetailsService.addPushDetails(pushId, userIds));
    }

    /**
     * 删除选中
     */
    @DeleteMapping("/delete/{pushId}/{ids}")
    public AjaxResult delete(@PathVariable Long pushId, @PathVariable List<Long> ids) {
        LambdaQueryWrapper<SchoolMessageParentsPushsDetails> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolMessageParentsPushsDetails::getPushId, pushId)
                .in(SchoolMessageParentsPushsDetails::getId, ids)
        ;
        return toAjax(schoolMessageParentsPushsDetailsService.remove(lqw));
    }
}
